/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListTextButtonEntry;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.graphics.CursorBox;

public abstract class CategorySettingsListMainEntry<D extends GuiCategoryUIEditorExpandableData<?>>
extends CategorySettingsListEntry {
    private final ConnectionLineType lineType;
    protected final GuiCategoryUIEditorExpandableData<D> data;

    public CategorySettingsListMainEntry(int screenWidth, int index, GuiCategorySettings.SettingRowList rowList, ConnectionLineType lineType, GuiCategoryUIEditorExpandableData<D> data) {
        super(0, 0, screenWidth, 24, index, rowList, () -> null);
        this.lineType = lineType;
        this.data = data;
    }

    protected void addHelpElement(Supplier<CursorBox> helpTooltipSupplier) {
        if (helpTooltipSupplier != null) {
            this.withSubEntry((int x, int y, int w, int h, CategorySettingsListMainEntry<?> root) -> new CategorySettingsListTextButtonEntry(x - 24, y + 2, this.index, this.rowList, "?", -5592406, -1, 5, () -> false, this, helpTooltipSupplier));
        }
    }

    @Override
    public CategorySettingsListEntry render(PoseStack poseStack, int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, Font font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        CategorySettingsListEntry result = super.render(poseStack, index, rowWidth, rowHeight, relativeMouseX, relativeMouseY, isMouseOver, partialTicks, font, globalMouseX, globalMouseY, includesSelected, isRoot);
        int xOffset = rowWidth / 2 - 110;
        int yOffset = 8;
        if (this.lineType == ConnectionLineType.TAIL_LEAF || this.lineType == ConnectionLineType.HEAD_LEAF) {
            int leftX = xOffset - 14;
            int rightX = xOffset - 2;
            int bottomY = yOffset + 4;
            int topY = yOffset - 24 + 4;
            CategorySettingsListMainEntry.m_93154_((PoseStack)poseStack, (int)leftX, (int)rightX, (int)bottomY, (int)-5592406);
            CategorySettingsListMainEntry.m_93222_((PoseStack)poseStack, (int)leftX, (int)topY, (int)bottomY, (int)-5592406);
            CategorySettingsListMainEntry.m_93222_((PoseStack)poseStack, (int)(rightX - 1), (int)(bottomY - 2), (int)(bottomY + 2), (int)-5592406);
            CategorySettingsListMainEntry.m_93222_((PoseStack)poseStack, (int)(rightX - 2), (int)(bottomY - 3), (int)(bottomY + 3), (int)-5592406);
            if (this.lineType == ConnectionLineType.HEAD_LEAF) {
                CategorySettingsListMainEntry.m_93154_((PoseStack)poseStack, (int)leftX, (int)rightX, (int)topY, (int)-5592406);
            }
        } else if (this.lineType == ConnectionLineType.PATH) {
            int topY = yOffset - 24 + 9;
            int bottomY = yOffset - 2;
            int lineX = xOffset + 12;
            CategorySettingsListMainEntry.m_93154_((PoseStack)poseStack, (int)(lineX - 2), (int)(lineX + 2), (int)(bottomY - 3), (int)-5592406);
            CategorySettingsListMainEntry.m_93154_((PoseStack)poseStack, (int)(lineX - 1), (int)(lineX + 1), (int)(bottomY - 2), (int)-5592406);
            CategorySettingsListMainEntry.m_93222_((PoseStack)poseStack, (int)lineX, (int)topY, (int)bottomY, (int)-5592406);
        }
        return result;
    }

    public CategorySettingsListMainEntry<D> withSubEntry(CenteredEntryFactory entryFactory) {
        super.withSubEntry(entryFactory.get(this.rowList.m_5759_() / 2 - 110 - 1, 0, 220, 24, this));
        return this;
    }

    @Override
    protected boolean selectAction() {
        return false;
    }

    @FunctionalInterface
    public static interface CenteredEntryFactory {
        public CategorySettingsListEntry get(int var1, int var2, int var3, int var4, CategorySettingsListMainEntry<?> var5);
    }
}

