/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.Loader;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VertexCollector
implements MultiBufferSource {
    protected final Set<Vector3f> vertices = Sets.newHashSet();
    protected final Vector3f currentVertex = new Vector3f();
    protected int currentAlpha = 255;
    protected int defaultAlpha = 255;
    private static Boolean useSodiumVersion = null;

    protected VertexCollector() {
    }

    public static VertexCollector create() {
        if (useSodiumVersion == null) {
            try {
                useSodiumVersion = ModList.get().isLoaded("rubidium") && ((ModContainer)ModList.get().getModContainerById("rubidium").get()).getModInfo().getVersion().equals(new DefaultArtifactVersion("0.6.4"));
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (useSodiumVersion != null && useSodiumVersion.booleanValue()) {
            try {
                return (VertexCollector)Class.forName("com.anthonyhilyard.iceberg.renderer.VertexCollectorSodium").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return new VertexCollector();
    }

    public VertexConsumer m_6299_(RenderType renderType) {
        return new VertexConsumer(){

            public VertexConsumer m_5483_(double x, double y, double z) {
                VertexCollector.this.currentVertex.set((float)x, (float)y, (float)z);
                VertexCollector.this.currentAlpha = VertexCollector.this.defaultAlpha;
                return this;
            }

            public VertexConsumer m_6122_(int r, int g, int b, int a) {
                VertexCollector.this.currentAlpha = a;
                return this;
            }

            public VertexConsumer m_7421_(float u, float v) {
                return this;
            }

            public VertexConsumer m_7122_(int x, int y) {
                return this;
            }

            public VertexConsumer m_7120_(int u, int v) {
                return this;
            }

            public VertexConsumer m_5601_(float x, float y, float z) {
                return this;
            }

            public void m_5752_() {
                if (VertexCollector.this.currentAlpha >= 25) {
                    VertexCollector.this.vertices.add(new Vector3f((Vector3fc)VertexCollector.this.currentVertex));
                }
            }

            public void m_7404_(int r, int g, int b, int a) {
                VertexCollector.this.defaultAlpha = a;
            }

            public void m_141991_() {
                VertexCollector.this.defaultAlpha = 255;
            }
        };
    }

    public Set<Vector3f> getVertices() {
        return this.vertices;
    }
}

