/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticType;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsRegistry;
import net.valhelsia.valhelsia_core.client.cosmetics.elytra.ModifyTextureModifier;
import net.valhelsia.valhelsia_core.client.cosmetics.source.ValhelsiaCosmeticsSource;
import net.valhelsia.valhelsia_core.client.model.BeanieModel;
import net.valhelsia.valhelsia_core.client.model.CapModel;
import net.valhelsia.valhelsia_core.client.model.CauldronBackpackModel;
import net.valhelsia.valhelsia_core.client.model.FlamingoFloatModel;
import net.valhelsia.valhelsia_core.client.model.PropellerCapModel;
import net.valhelsia.valhelsia_core.client.model.ScarfModel;
import net.valhelsia.valhelsia_core.client.model.ValhelsiaCapeModel;
import net.valhelsia.valhelsia_core.client.model.WitchHatModel;
import net.valhelsia.valhelsia_core.client.model.WitchsBroomModel;
import net.valhelsia.valhelsia_core.client.model.WitchsWandModel;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.helper.block.BlockRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.BlockRegistryObject;

public class ClientSetup {
    public ClientSetup() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        this.registerCosmetics();
        ValhelsiaCore.REGISTRY_MANAGERS.values().forEach(registryManager -> {
            if (!registryManager.hasHelper(ForgeRegistries.Keys.BLOCKS)) {
                return;
            }
            BlockRegistryHelper registryHelper = registryManager.getBlockHelper();
            registryHelper.getRegistryClasses().forEach(registryClass -> {
                for (Field field : ((RegistryClass)registryClass.get()).getClass().getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(net.valhelsia.valhelsia_core.core.registry.helper.block.RenderType.class)) continue;
                    net.valhelsia.valhelsia_core.core.registry.helper.block.RenderType renderType = field.getAnnotation(net.valhelsia.valhelsia_core.core.registry.helper.block.RenderType.class);
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        try {
                            Collection collection = (Collection)field.get(null);
                            collection.forEach(block -> {
                                if (block instanceof BlockRegistryObject) {
                                    BlockRegistryObject registryObject = (BlockRegistryObject)block;
                                    this.setRenderLayer(registryObject, renderType);
                                }
                            });
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (Map.class.isAssignableFrom(field.getType())) {
                        try {
                            Map map = (Map)field.get(null);
                            map.forEach((o, o2) -> {
                                if (o instanceof BlockRegistryObject) {
                                    BlockRegistryObject registryObject = (BlockRegistryObject)o;
                                    this.setRenderLayer(registryObject, renderType);
                                } else if (o2 instanceof BlockRegistryObject) {
                                    BlockRegistryObject registryObject = (BlockRegistryObject)o2;
                                    this.setRenderLayer(registryObject, renderType);
                                }
                            });
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        this.setRenderLayer((BlockRegistryObject)field.get(null), renderType);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        });
    }

    private void registerCosmetics() {
        ValhelsiaCosmeticsSource source = new ValhelsiaCosmeticsSource("valhelsia_core");
        CosmeticsRegistry.addSource(source);
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.BACK, ValhelsiaCapeModel::new).nameContains("valhelsia_cape").elytraModifier(new ModifyTextureModifier(key -> "elytra")));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.HAT, WitchHatModel::new).nameContains("witch_hat"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.SPECIAL, WitchsBroomModel::new).exactName("witchs_broom"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.HAND, WitchsWandModel::new).nameContains("witchs_wand"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.BACK, CauldronBackpackModel::new).exactName("cauldron_backpack"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.HAT, BeanieModel::new).nameContains("beanie"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.FACE, ScarfModel::new).nameContains("scarf"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.HAT, PropellerCapModel::new).exactName("propeller_cap"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.HAT, CapModel::new).nameContains("cap"));
        CosmeticsRegistry.registerType(source, CosmeticType.builder(CosmeticsCategory.SPECIAL, FlamingoFloatModel::new).exactName("flamingo_float"));
    }

    private void setRenderLayer(BlockRegistryObject<Block> block, net.valhelsia.valhelsia_core.core.registry.helper.block.RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)renderType.value().getRenderType().get());
    }
}

