/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.util.Mth;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.gui.component.CosmeticsEntry;
import net.valhelsia.valhelsia_core.client.gui.screen.CosmeticsListEntry;
import net.valhelsia.valhelsia_core.client.gui.screen.CosmeticsWardrobeScreen;

public class CosmeticsList
extends ContainerObjectSelectionList<CosmeticsListEntry> {
    private static final int ENTRY_SPACING = 10;
    private static final int ENTRY_WIDTH = 88;
    private static final int ENTRY_HEIGHT = 100;
    private final List<CosmeticsEntry> entries = new ArrayList<CosmeticsEntry>();
    private final Minecraft minecraft;
    private CosmeticsWardrobeScreen screen;
    private final Button.OnPress onPress = button -> {
        CosmeticsEntry entry = (CosmeticsEntry)button;
        if (entry.isSelected()) {
            entry.setSelected(false);
            this.screen.getSelectedCosmetics().remove((Object)entry.getCategory());
        } else {
            entry.setSelected(true);
            this.entries.forEach(cosmeticsEntry -> {
                if (cosmeticsEntry != button) {
                    cosmeticsEntry.setSelected(false);
                }
            });
            this.screen.getSelectedCosmetics().put(entry.getCategory(), entry.getCosmetic());
        }
    };
    private final int rowCount;

    public CosmeticsList(Minecraft minecraft, CosmeticsWardrobeScreen screen, int width, int height, int y0, int y1) {
        super(minecraft, width, height, y0, y1, 110);
        this.screen = screen;
        this.minecraft = minecraft;
        this.rowCount = this.m_5759_() / 98;
        this.m_93488_(false);
        this.m_93496_(false);
    }

    public void update(CosmeticsCategory category) {
        this.m_6702_().clear();
        CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
        UUID uuid = this.minecraft.m_91094_().m_92548_().getId();
        List<CosmeticKey> cosmetics = cosmeticsManager.getCosmetics(uuid, category);
        this.entries.clear();
        this.m_93410_(0.0);
        for (int i = 0; i < cosmetics.size(); ++i) {
            CosmeticsEntry leftEntry = new CosmeticsEntry(category, cosmetics.get(i), this.m_5747_(), 0, 88, 100, this.onPress, cosmetics.get(i).equals(this.screen.getSelectedCosmetics().get((Object)category)));
            CosmeticsEntry rightEntry = null;
            this.entries.add(leftEntry);
            if (i + 1 != cosmetics.size() && this.rowCount != 1) {
                rightEntry = new CosmeticsEntry(category, cosmetics.get(++i), this.m_5747_() + 88 + 10, 0, 88, 100, this.onPress, cosmetics.get(i).equals(this.screen.getSelectedCosmetics().get((Object)category)));
                this.entries.add(rightEntry);
            }
            this.m_7085_((AbstractSelectionList.Entry)new CosmeticsListEntry(this, leftEntry, rightEntry));
        }
    }

    public int m_5759_() {
        return this.m_93520_() - this.m_5747_();
    }

    public int m_5747_() {
        return (int)((float)this.f_93388_ / 5.73f);
    }

    public int m_93520_() {
        return (int)((float)this.f_93388_ / 2.07f);
    }

    protected int m_7610_(int index) {
        return super.m_7610_(index);
    }

    protected int m_5756_() {
        return this.m_93520_() + 10;
    }

    public void m_86412_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        double scale = this.getMinecraft().m_91268_().m_85449_();
        RenderSystem.m_69488_((int)((int)((double)this.m_5747_() * scale)), (int)((int)((double)(this.f_93389_ - this.f_93391_) * scale)), (int)((int)((double)(this.m_5756_() + 6) * scale)), (int)((int)((double)(this.f_93389_ - (this.f_93389_ - this.f_93391_) - this.f_93390_) * scale)));
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69471_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Nullable
    public CosmeticsListEntry getEntryAtPosition(double mouseX, double mouseY) {
        int left = this.m_5747_();
        int right = this.m_93520_();
        int i1 = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int j1 = i1 / this.f_93387_;
        return mouseX < (double)this.m_5756_() && mouseX >= (double)left && mouseX <= (double)right && j1 >= 0 && i1 >= 0 && j1 < this.m_5773_() ? (CosmeticsListEntry)((Object)this.m_6702_().get(j1)) : null;
    }

    private Minecraft getMinecraft() {
        return this.minecraft;
    }
}

