/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.helper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCapability;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCreator;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.common.util.counter.SerializableCounter;

public class CounterHelper {
    private static final List<CounterCreator<? extends SerializableCounter>> COUNTERS = new ArrayList<CounterCreator<? extends SerializableCounter>>();

    @SafeVarargs
    public static void addCounters(CounterCreator<? extends SerializableCounter> ... counterCreators) {
        for (CounterCreator<? extends SerializableCounter> counterCreator : counterCreators) {
            CounterHelper.addCounter(counterCreator);
        }
    }

    public static void addCounter(CounterCreator<? extends SerializableCounter> counterCreator) {
        COUNTERS.add(counterCreator);
    }

    public static List<CounterCreator<? extends SerializableCounter>> getCounters() {
        return COUNTERS;
    }

    @Nullable
    public static SerializableCounter getCounter(Player player, ResourceLocation resourceLocation) {
        if (player.getCapability(CounterProvider.CAPABILITY).resolve().isPresent()) {
            return ((CounterCapability)player.getCapability(CounterProvider.CAPABILITY).resolve().get()).getCounter(resourceLocation);
        }
        return null;
    }
}

