/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.common.network.NetworkHandler;
import net.valhelsia.valhelsia_core.common.network.UploadCosmeticsPacket;

public record RequestCosmeticsPacket(UUID uuid) {
    public static void encode(RequestCosmeticsPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.uuid);
    }

    public static RequestCosmeticsPacket decode(FriendlyByteBuf buffer) {
        return new RequestCosmeticsPacket(buffer.m_130259_());
    }

    public static void consume(RequestCosmeticsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                UUID uuid = Minecraft.m_91087_().m_91094_().m_92548_().getId();
                NetworkHandler.sendToServer(new UploadCosmeticsPacket(uuid, CosmeticsManager.getInstance().getActiveCosmetics(uuid, false).writeToTag(new CompoundTag()), packet.uuid));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

