/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.world.structure.jigsaw;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.Nullable;

public class JigsawBuilder {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("empty"));
    private final ResourceKey<StructureTemplatePool> key;
    @Nullable
    private final String folder;
    private final List<ElementInfo> elements = new ArrayList<ElementInfo>();
    private final BootstapContext<StructureTemplatePool> context;
    private final ElementFunction elementFunction;
    private StructureTemplatePool.Projection projection = StructureTemplatePool.Projection.RIGID;
    private ResourceKey<StructureProcessorList> processors = EMPTY_PROCESSOR_LIST;

    private JigsawBuilder(ResourceKey<StructureTemplatePool> key, @Nullable String folder, BootstapContext<StructureTemplatePool> context, @Nullable ElementFunction elementFunction) {
        this.key = key;
        this.folder = folder;
        this.context = context;
        this.elementFunction = Objects.requireNonNullElseGet(elementFunction, () -> (resourceLocation, holder, projection, terrainAdjustment) -> StructurePoolElement.m_210531_((String)resourceLocation.toString(), (Holder)holder));
    }

    public static JigsawBuilder builder(ResourceKey<StructureTemplatePool> key, String folder, BootstapContext<StructureTemplatePool> context, @Nullable ElementFunction elementFunction) {
        return new JigsawBuilder(key, folder, context, elementFunction);
    }

    public static JigsawBuilder builder(ResourceKey<StructureTemplatePool> key, BootstapContext<StructureTemplatePool> context, @Nullable ElementFunction elementFunction) {
        return new JigsawBuilder(key, null, context, elementFunction);
    }

    public JigsawBuilder projection(StructureTemplatePool.Projection projection) {
        this.projection = projection;
        return this;
    }

    public JigsawBuilder element(String location) {
        return this.element(location, 1);
    }

    public JigsawBuilder element(String location, TerrainAdjustment terrainAdjustment) {
        return this.element(location, 1, terrainAdjustment);
    }

    public JigsawBuilder element(String location, int weight) {
        this.elements.add(ElementInfo.of((String)(this.folder != null ? this.folder + "/" + location : location), weight, null));
        return this;
    }

    public JigsawBuilder element(String location, int weight, TerrainAdjustment terrainAdjustment) {
        this.elements.add(ElementInfo.of((String)(this.folder != null ? this.folder + "/" + location : location), weight, terrainAdjustment));
        return this;
    }

    public JigsawBuilder processors(ResourceKey<StructureProcessorList> processors) {
        this.processors = processors;
        return this;
    }

    public void build(String modId, @Nullable TerrainAdjustment terrainAdjustment) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        Holder.Reference processorListHolder = this.context.m_255420_(Registries.f_257011_).m_255043_(this.processors);
        Holder.Reference fallbackPoolHolder = this.context.m_255420_(Registries.f_256948_).m_255043_(Pools.f_127186_);
        for (ElementInfo info : this.elements) {
            list.add(Pair.of(this.elementFunction.apply(new ResourceLocation(modId, info.location()), (Holder<StructureProcessorList>)processorListHolder, this.projection, terrainAdjustment), (Object)info.weight));
        }
        this.context.m_255272_(this.key, (Object)new StructureTemplatePool((Holder)fallbackPoolHolder, list, this.projection));
    }

    @FunctionalInterface
    public static interface ElementFunction {
        public Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> apply(ResourceLocation var1, Holder<StructureProcessorList> var2, StructureTemplatePool.Projection var3, @Nullable TerrainAdjustment var4);
    }

    private record ElementInfo(String location, Integer weight, @Nullable TerrainAdjustment terrainAdjustment) {
        private static ElementInfo of(String location, Integer weight, @Nullable TerrainAdjustment terrainAdjustment) {
            return new ElementInfo(location, weight, terrainAdjustment);
        }
    }
}

