/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.helper.DatapackRegistryClass;
import net.valhelsia.valhelsia_core.core.registry.helper.DatapackRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.MappedRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.RegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.BlockRegistryHelper;
import org.apache.commons.lang3.function.TriFunction;

public abstract class RegistryCollector {
    private final Map<ResourceKey<? extends Registry<?>>, RegistryHelper<?, ?>> registryHelpers = new HashMap();
    private final String modId;

    public RegistryCollector(String modId) {
        this.modId = modId;
        this.collect();
    }

    protected abstract void collect();

    @SafeVarargs
    public final void addBlockHelper(Supplier<RegistryClass> ... registryClasses) {
        this.addMappedHelper(Registries.f_256747_, BlockRegistryHelper::new, registryClasses);
    }

    @SafeVarargs
    public final void addItemHelper(Supplier<RegistryClass> ... registryClasses) {
        this.addMappedHelper(Registries.f_256913_, ItemRegistryHelper::new, registryClasses);
    }

    @SafeVarargs
    public final <T> void addMappedHelper(ResourceKey<Registry<T>> key, Supplier<RegistryClass> ... registryClasses) {
        this.registryHelpers.put(key, new MappedRegistryHelper<T>(key, this.modId, (ImmutableList<Supplier<RegistryClass>>)ImmutableList.copyOf((Object[])registryClasses)));
    }

    @SafeVarargs
    public final <T> void addMappedHelper(ResourceKey<Registry<T>> key, TriFunction<ResourceKey<Registry<T>>, String, ImmutableList<Supplier<RegistryClass>>, MappedRegistryHelper<T>> registryHelper, Supplier<RegistryClass> ... registryClasses) {
        this.registryHelpers.put(key, (RegistryHelper)registryHelper.apply(key, (Object)this.modId, (Object)ImmutableList.copyOf((Object[])registryClasses)));
    }

    @SafeVarargs
    public final <T> void addDatapackHelper(ResourceKey<Registry<T>> key, BiFunction<DataProviderInfo, BootstapContext<T>, DatapackRegistryClass<T>> ... classCollectors) {
        this.registryHelpers.put(key, new DatapackRegistryHelper<T>(key, this.modId, (info, context) -> Arrays.stream(classCollectors).map(function -> (DatapackRegistryClass)function.apply(info, context)).collect(Collectors.toUnmodifiableList())));
    }

    public final <T> void addDatapackHelper(ResourceKey<Registry<T>> key, TriFunction<ResourceKey<Registry<T>>, String, DatapackClassCollector, DatapackRegistryHelper<T>> registryHelper, DatapackClassCollector classCollector) {
        this.registryHelpers.put(key, (RegistryHelper)registryHelper.apply(key, (Object)this.modId, (Object)classCollector));
    }

    protected ImmutableMap<ResourceKey<? extends Registry<?>>, RegistryHelper<?, ?>> getHelpers() {
        return ImmutableMap.copyOf(this.registryHelpers);
    }

    protected String getModId() {
        return this.modId;
    }

    @FunctionalInterface
    public static interface DatapackClassCollector {
        public List<DatapackRegistryClass<?>> collect(DataProviderInfo var1, BootstapContext<?> var2);
    }
}

