/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.DoNotCall;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.RegistryCollector;
import net.valhelsia.valhelsia_core.core.registry.helper.DatapackRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.MappedRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.RegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.helper.block.BlockRegistryHelper;

public record RegistryManager(String modId, ImmutableMap<ResourceKey<? extends Registry<?>>, RegistryHelper<?, ? extends RegistryClass>> registryHelpers, @Nullable AbstractConfigValidator configValidator) {
    public RegistryManager(RegistryCollector collector, @Nullable AbstractConfigValidator configValidator) {
        this(collector.getModId(), collector.getHelpers(), configValidator);
    }

    public <T> boolean hasHelper(ResourceKey<Registry<T>> registryResourceKey) {
        return this.registryHelpers.containsKey(registryResourceKey);
    }

    public <T, H extends MappedRegistryHelper<T>> H getMappedHelper(ResourceKey<Registry<T>> registryResourceKey) {
        if (!this.hasHelper(registryResourceKey)) {
            throw new NullPointerException("Registry Manager for '" + this.modId() + "' has no Helper for registry: " + registryResourceKey.m_135782_());
        }
        return (H)((MappedRegistryHelper)this.registryHelpers.get(registryResourceKey));
    }

    public <T, H extends DatapackRegistryHelper<T>> H getDatapackHelper(ResourceKey<Registry<T>> registryResourceKey) {
        if (!this.hasHelper(registryResourceKey)) {
            throw new NullPointerException("Registry Manager for '" + this.modId() + "' has no Helper for registry: " + registryResourceKey.m_135782_());
        }
        return (H)((DatapackRegistryHelper)this.registryHelpers.get(registryResourceKey));
    }

    public BlockRegistryHelper getBlockHelper() {
        return (BlockRegistryHelper)this.getMappedHelper(ForgeRegistries.Keys.BLOCKS);
    }

    public ItemRegistryHelper getItemHelper() {
        return (ItemRegistryHelper)this.getMappedHelper(ForgeRegistries.Keys.ITEMS);
    }

    @DoNotCall
    public void register(IEventBus eventBus) {
        for (RegistryHelper registryHelper2 : this.registryHelpers.values()) {
            if (!(registryHelper2 instanceof MappedRegistryHelper)) continue;
            registryHelper2.getRegistryClasses().forEach(Supplier::get);
        }
        this.registryHelpers.values().forEach(registryHelper -> {
            if (registryHelper instanceof MappedRegistryHelper) {
                MappedRegistryHelper mappedRegistryHelper = (MappedRegistryHelper)registryHelper;
                mappedRegistryHelper.registerDeferredRegister(eventBus);
                if (mappedRegistryHelper instanceof ItemRegistryHelper) {
                    ItemRegistryHelper itemRegistryHelper = (ItemRegistryHelper)mappedRegistryHelper;
                    if (this.hasHelper(Registries.f_256747_)) {
                        itemRegistryHelper.registerBlockItems(this.getBlockHelper());
                    }
                }
            }
        });
    }

    public RegistrySetBuilder buildRegistrySet(DataProviderInfo info) {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        for (RegistryHelper helper : this.registryHelpers.values()) {
            if (!(helper instanceof DatapackRegistryHelper)) continue;
            DatapackRegistryHelper datapackRegistryHelper = (DatapackRegistryHelper)helper;
            Function<BootstapContext, List> function = context -> datapackRegistryHelper.getClassCollector().collect(info, (BootstapContext<?>)context);
            builder.m_254916_(datapackRegistryHelper.getRegistry(), function::apply);
        }
        return builder;
    }
}

