/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry.helper;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.DoNotCall;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.helper.RegistryHelper;

public class MappedRegistryHelper<T>
extends RegistryHelper<T, RegistryClass> {
    private final DeferredRegister<T> deferredRegister;
    private final ImmutableList<Supplier<RegistryClass>> registryClasses;

    public MappedRegistryHelper(ResourceKey<? extends Registry<T>> registry, String modId, ImmutableList<Supplier<RegistryClass>> registryClasses) {
        super(registry, modId);
        this.deferredRegister = this.createDeferredRegister(registry, modId);
        this.registryClasses = registryClasses;
    }

    private DeferredRegister<T> createDeferredRegister(ResourceKey<? extends Registry<?>> key, String modId) {
        return DeferredRegister.create((ResourceLocation)key.m_135782_(), (String)modId);
    }

    public Collection<RegistryObject<T>> getRegistryObjects() {
        return this.deferredRegister.getEntries();
    }

    @DoNotCall
    public final void registerDeferredRegister(IEventBus eventBus) {
        this.deferredRegister.register(eventBus);
    }

    public final <O extends T> RegistryObject<O> register(String name, Supplier<O> object) {
        return this.deferredRegister.register(name, object);
    }

    @Override
    public ImmutableList<Supplier<RegistryClass>> getRegistryClasses() {
        return this.registryClasses;
    }
}

