/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry.helper.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.registry.helper.block.ToolTier;
import net.valhelsia.valhelsia_core.core.registry.helper.block.ToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockRegistryObject<T extends Block>
implements Supplier<T> {
    private static final ItemFunction DEFAULT_ITEM_FUNCTION = registryObject -> new BlockItem((Block)registryObject.get(), new Item.Properties());
    private final String name;
    private final RegistryObject<T> registryObject;
    @Nullable
    private ToolType toolType = null;
    @Nullable
    private ToolTier toolTier = null;
    @Nullable
    private ItemFunction itemFunction;

    public BlockRegistryObject(String name, RegistryObject<T> registryObject) {
        this.name = name;
        this.registryObject = registryObject;
    }

    public static <T extends Block> BlockRegistryObject<T> of(String name, RegistryObject<T> registryObject) {
        return new BlockRegistryObject<T>(name, registryObject);
    }

    @Override
    @NotNull
    public T get() {
        return (T)((Block)this.registryObject.get());
    }

    public BlockRegistryObject<T> withItem() {
        return this.withItem(DEFAULT_ITEM_FUNCTION);
    }

    public BlockRegistryObject<T> withItem(ItemFunction function) {
        this.itemFunction = function;
        return this;
    }

    public final BlockRegistryObject<T> toolType(ToolType toolType) {
        this.toolType = toolType;
        return this;
    }

    public final BlockRegistryObject<T> toolTier(ToolTier toolTier) {
        this.toolTier = toolTier;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RegistryObject<T> getRegistryObject() {
        return this.registryObject;
    }

    @Nullable
    public ItemFunction getItemFunction() {
        return this.itemFunction;
    }

    public Optional<ToolType> getToolType() {
        return Optional.ofNullable(this.toolType);
    }

    public Optional<ToolTier> getToolTier() {
        return Optional.ofNullable(this.toolTier);
    }

    @FunctionalInterface
    public static interface ItemFunction {
        public BlockItem apply(RegistryObject<? extends Block> var1);
    }
}

