/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data.recipes;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.data.recipes.RecipePart;
import net.valhelsia.valhelsia_core.data.recipes.ValhelsiaRecipeProvider;
import net.valhelsia.valhelsia_core.data.recipes.ValhelsiaShapedRecipeBuilder;

public abstract class RecipeSubProvider {
    private final ValhelsiaRecipeProvider provider;

    public RecipeSubProvider(ValhelsiaRecipeProvider provider) {
        this.provider = provider;
    }

    protected abstract void registerRecipes();

    public void add(RecipeBuilder builder) {
        builder.m_176498_(this.provider.getFinishedRecipeConsumer());
    }

    public void add(RecipeBuilder builder, String path) {
        builder.m_126140_(this.provider.getFinishedRecipeConsumer(), new ResourceLocation(this.provider.getModId(), path));
    }

    public void storageRecipe(ItemLike item, ItemLike block) {
        this.storageRecipe(item, block, null, null);
    }

    public void storageRecipe(ItemLike item, ItemLike block, @Nullable String groupItem, @Nullable String groupBlock) {
        this.shaped(RecipeCategory.MISC, block, builder -> builder.group(groupBlock).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy(this, item), this.getName(block) + "_from_" + this.getName(item));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, item, 9, builder -> builder.m_126145_(groupItem).m_126209_(block).m_126132_("has_item", (CriterionTriggerInstance)RecipeSubProvider.has(block)), this.getName(item) + "_from_" + this.getName(block));
    }

    public void simple2x2(RecipeCategory category, ItemLike result, RecipePart<?> item) {
        this.shaped(category, result, builder -> builder.pattern("##").pattern("##").define(Character.valueOf('#'), item).unlockedBy(this, item));
    }

    public void singleRow(RecipeCategory category, ItemLike result, RecipePart<?> item) {
        this.shaped(category, result, builder -> builder.pattern("###").define(Character.valueOf('#'), item).unlockedBy(this, item));
    }

    public void surroundingItem(RecipeCategory category, ItemLike result, RecipePart<?> middle, RecipePart<?> outside, int amount) {
        this.shaped(category, result, amount, builder -> builder.pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), outside).define(Character.valueOf('X'), middle).unlockedBy(this.getHasName(middle), (CriterionTriggerInstance)this.has(middle)).unlockedBy(this, outside));
    }

    public void wood(ItemLike result, RecipePart<?> log) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 3, builder -> builder.group("bark").pattern("##").pattern("##").define(Character.valueOf('#'), log).unlockedBy(this, log));
    }

    public void planks(ItemLike result, TagKey<Item> log) {
        this.planks(result, log, 4);
    }

    public void planks(ItemLike result, TagKey<Item> log, int count) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, result, count, builder -> builder.m_206419_(log).m_126132_("has_log", (CriterionTriggerInstance)RecipeSubProvider.has(log)));
    }

    public void slab(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 6, builder -> builder.pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void woodenSlab(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 6, builder -> builder.group("wooden_slab").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void stairs(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 4, builder -> builder.pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void sword(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.COMBAT, result, builder -> builder.pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, material));
    }

    public void shovel(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.TOOLS, result, builder -> builder.pattern("#").pattern("X").pattern("X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, material));
    }

    public void pickaxe(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.TOOLS, result, builder -> builder.pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, material));
    }

    public void axe(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.TOOLS, result, builder -> builder.pattern("##").pattern("#X").pattern(" X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, material));
    }

    public void hoe(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.TOOLS, result, builder -> builder.pattern("##").pattern(" X").pattern(" X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, material));
    }

    public void helmet(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.COMBAT, result, builder -> builder.pattern("###").pattern("# #").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void chestplate(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.COMBAT, result, builder -> builder.pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void leggings(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.COMBAT, result, builder -> builder.pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void boots(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.COMBAT, result, builder -> builder.pattern("# #").pattern("# #").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void boat(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.TRANSPORTATION, result, builder -> builder.pattern("# #").pattern("###").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void chestBoat(ItemLike result, ItemLike boat) {
        this.shapeless(RecipeCategory.TRANSPORTATION, result, builder -> builder.m_126209_(boat).m_206419_(Tags.Items.CHESTS_WOODEN).m_126132_("has_" + this.getName(boat), (CriterionTriggerInstance)RecipeSubProvider.has(boat)).m_126132_("has_chest", (CriterionTriggerInstance)RecipeSubProvider.has((TagKey<Item>)Tags.Items.CHESTS_WOODEN)));
    }

    public void glassPane(ItemLike result, RecipePart<?> glass) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 16, builder -> builder.pattern("###").pattern("###").define(Character.valueOf('#'), glass).unlockedBy(this, glass));
    }

    public void woodenStairs(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 4, builder -> builder.group("wooden_stairs").pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void sign(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.DECORATIONS, result, 3, builder -> builder.pattern("###").pattern("###").pattern(" X ").define(Character.valueOf('#'), planks).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, planks));
    }

    public void door(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 3, builder -> builder.pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void trapdoor(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 2, builder -> builder.pattern("###").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void fence(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 3, builder -> builder.pattern("#X#").pattern("#X#").define(Character.valueOf('#'), planks).define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, planks));
    }

    public void fenceGate(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, builder -> builder.pattern("#X#").pattern("#X#").define(Character.valueOf('X'), planks).define(Character.valueOf('#'), (TagKey<Item>)Tags.Items.RODS_WOODEN).unlockedBy(this, planks));
    }

    public void button(ItemLike result, ItemLike planks) {
        this.shapeless(RecipeCategory.REDSTONE, result, builder -> builder.m_126209_(planks).m_126132_("has_planks", (CriterionTriggerInstance)RecipeSubProvider.has(planks)));
    }

    public void pressurePlate(ItemLike result, RecipePart<?> planks) {
        this.shaped(RecipeCategory.REDSTONE, result, builder -> builder.pattern("##").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void carpet(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.DECORATIONS, result, 3, builder -> builder.pattern("##").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void shaped(RecipeCategory category, ItemLike result, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe) {
        this.add((RecipeBuilder)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result))).builder());
    }

    public void shaped(RecipeCategory category, ItemLike result, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe, String path) {
        this.add((RecipeBuilder)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result))).builder(), path);
    }

    public void shaped(RecipeCategory category, ItemLike result, int count, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe) {
        this.add((RecipeBuilder)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result, count))).builder());
    }

    public void shaped(RecipeCategory category, ItemLike result, int count, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe, String path) {
        this.add((RecipeBuilder)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result, count))).builder(), path);
    }

    public void shapeless(RecipeCategory category, ItemLike result, UnaryOperator<ShapelessRecipeBuilder> recipe) {
        this.add((RecipeBuilder)recipe.apply(ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)result)));
    }

    public void shapeless(RecipeCategory category, ItemLike result, UnaryOperator<ShapelessRecipeBuilder> recipe, String path) {
        this.add((RecipeBuilder)recipe.apply(ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)result)), path);
    }

    public void shapeless(RecipeCategory category, ItemLike result, int count, UnaryOperator<ShapelessRecipeBuilder> recipe) {
        this.add((RecipeBuilder)recipe.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result, (int)count)));
    }

    public void shapeless(RecipeCategory category, ItemLike result, int count, UnaryOperator<ShapelessRecipeBuilder> recipe, String path) {
        this.add((RecipeBuilder)recipe.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result, (int)count)), path);
    }

    public String getName(ItemLike item) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        if (key == null) {
            return "";
        }
        return key.m_135815_();
    }

    public InventoryChangeTrigger.TriggerInstance has(RecipePart<?> part) {
        Object obj = part.get();
        if (obj instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)obj;
            return RecipeSubProvider.has(itemLike);
        }
        obj = part.get();
        if (obj instanceof TagKey) {
            TagKey tagKey = (TagKey)obj;
            return RecipeSubProvider.has((TagKey<Item>)tagKey);
        }
        obj = part.get();
        if (obj instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)obj;
            ItemLike[] itemLikes = (ItemLike[])Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).toArray(ItemLike[]::new);
            return RecipeSubProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(itemLikes).m_45077_());
        }
        throw new IllegalArgumentException("Invalid type: " + part.get().getClass());
    }

    public String getHasName(RecipePart<?> part) {
        Object obj = part.get();
        if (obj instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)obj;
            return RecipeSubProvider.getHasName(itemLike);
        }
        obj = part.get();
        if (obj instanceof TagKey) {
            TagKey tagKey = (TagKey)obj;
            return "has_" + tagKey.f_203868_().m_135815_();
        }
        if (part.get() instanceof Ingredient) {
            return "has_item";
        }
        throw new IllegalArgumentException("Invalid type: " + part.get().getClass());
    }

    public RecipePart<ItemLike> item(ItemLike itemLike) {
        return RecipePart.of(itemLike);
    }

    public RecipePart<TagKey<Item>> tag(TagKey<Item> itemTagKey) {
        return RecipePart.of(itemTagKey);
    }

    public RecipePart<Ingredient> ingredient(Ingredient ingredient) {
        return RecipePart.of(ingredient);
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike itemLike) {
        return RecipeSubProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tagKey) {
        return RecipeSubProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(tagKey).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    protected static String getHasName(ItemLike itemLike) {
        return "has_" + RecipeSubProvider.getItemName(itemLike);
    }

    protected static String getItemName(ItemLike itemLike) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_())).m_135815_();
    }
}

