/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data.recipes;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;
import net.valhelsia.valhelsia_core.core.data.ValhelsiaDataProvider;
import net.valhelsia.valhelsia_core.data.recipes.RecipeSubProvider;
import org.jetbrains.annotations.NotNull;

public class ValhelsiaRecipeProvider
extends RecipeProvider
implements ValhelsiaDataProvider {
    @Nonnull
    private Consumer<FinishedRecipe> finishedRecipeConsumer = finishedRecipe -> {};
    private final DataProviderInfo info;
    private final List<RecipeSubProvider> subProviders;

    @SafeVarargs
    public ValhelsiaRecipeProvider(DataProviderInfo info, Function<ValhelsiaRecipeProvider, RecipeSubProvider> ... subProviders) {
        super(info.output());
        this.info = info;
        this.subProviders = Arrays.stream(subProviders).map(function -> (RecipeSubProvider)function.apply(this)).toList();
    }

    @OverridingMethodsMustInvokeSuper
    protected void m_245200_(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.finishedRecipeConsumer = consumer;
        this.subProviders.forEach(RecipeSubProvider::registerRecipes);
    }

    @NotNull
    public Consumer<FinishedRecipe> getFinishedRecipeConsumer() {
        return this.finishedRecipeConsumer;
    }

    @Override
    public String getModId() {
        return this.info.registryManager().modId();
    }
}

