/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.common.world.AddNetherSpawnsBiomeModifier;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;
import net.valhelsia.valhelsia_core.core.registry.helper.DatapackRegistryClass;

public abstract class ValhelsiaBiomeModifierProvider
extends DatapackRegistryClass<BiomeModifier> {
    public HolderGetter<Biome> biomeRegistry;
    public HolderGetter<PlacedFeature> featureRegistry;
    public HolderSet.Named<Biome> isOverworld;
    public HolderSet.Named<Biome> isNether;
    public HolderSet.Named<Biome> isEnd;

    public ValhelsiaBiomeModifierProvider(DataProviderInfo info, BootstapContext<BiomeModifier> context) {
        super(info, context);
    }

    @Override
    public void init(BootstapContext<BiomeModifier> context) {
        this.biomeRegistry = context.m_255420_(Registries.f_256952_);
        this.featureRegistry = context.m_255420_(Registries.f_256988_);
        this.isOverworld = this.namedBiome((TagKey<Biome>)BiomeTags.f_215817_);
        this.isNether = this.namedBiome((TagKey<Biome>)BiomeTags.f_207612_);
        this.isEnd = this.namedBiome((TagKey<Biome>)BiomeTags.f_215818_);
    }

    public void addFeature(String name, HolderSet<Biome> biomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) {
        this.add(name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, features, step));
    }

    public void addSpawn(String name, HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData ... spawners) {
        this.add(name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(biomes, List.of(spawners)));
    }

    public void addNetherSpawn(String name, HolderSet<Biome> biomes, double charge, double energyBudget, MobSpawnSettings.SpawnerData ... spawners) {
        this.add(name, new AddNetherSpawnsBiomeModifier(biomes, Optional.empty(), List.of(spawners), charge, energyBudget));
    }

    public void addNetherSpawn(String name, HolderSet<Biome> biomes, MobCategory category, double charge, double energyBudget, MobSpawnSettings.SpawnerData ... spawners) {
        this.add(name, new AddNetherSpawnsBiomeModifier(biomes, Optional.of(category), List.of(spawners), charge, energyBudget));
    }

    public void add(String name, BiomeModifier modifier) {
        this.getContext().m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)this.getInfo().location(name)), (Object)modifier);
    }

    public HolderGetter<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public HolderGetter<PlacedFeature> getFeatureRegistry() {
        return this.featureRegistry;
    }

    @SafeVarargs
    public final HolderSet<Biome> directBiome(ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205809_((Holder[])((Holder[])Arrays.stream(biomes).map(arg_0 -> this.biomeRegistry.m_255043_(arg_0)).toArray(Holder[]::new)));
    }

    public final HolderSet.Named<Biome> namedBiome(TagKey<Biome> tagKey) {
        return this.biomeRegistry.m_254956_(tagKey);
    }

    @SafeVarargs
    public final HolderSet<PlacedFeature> directFeature(ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205809_((Holder[])((Holder[])Arrays.stream(features).map(arg_0 -> this.featureRegistry.m_255043_(arg_0)).toArray(Holder[]::new)));
    }
}

