/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen.provider;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModuleInfo;

public abstract class KiwiBlockLoot
extends BlockLootSubProvider {
    public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    public static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    public static final LootItemCondition.Builder HAS_SHEARS = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    public static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_7818_(HAS_SILK_TOUCH);
    public static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    public List<Block> knownBlocks;
    private final Map<Class<?>, Function<Block, LootTable.Builder>> handlers = Maps.newHashMap();
    private Function<Block, LootTable.Builder> defaultHandler;
    private final Set<Block> added = Sets.newHashSet();

    public KiwiBlockLoot(ResourceLocation moduleId, Set<Item> explosionResistant, FeatureFlagSet enabledFeatures) {
        super(explosionResistant, enabledFeatures);
        ModuleInfo info = KiwiModules.get(moduleId);
        Objects.requireNonNull(info);
        this.knownBlocks = info.getRegistries(ForgeRegistries.BLOCKS);
    }

    protected void handle(Class<? extends Block> clazz, Function<Block, LootTable.Builder> handler) {
        this.handlers.put(clazz, handler);
    }

    protected void handleDefault(Function<Block, LootTable.Builder> handler) {
        this.defaultHandler = handler;
    }

    protected final void m_245660_() {
        this.addTables();
        for (Block block : this.getKnownBlocks()) {
            if (this.added.contains(block)) continue;
            Function<Block, LootTable.Builder> handler = this.handlers.get(block.getClass());
            if (handler != null) {
                this.m_246481_(block, handler);
                continue;
            }
            if (this.defaultHandler == null) continue;
            this.m_246481_(block, this.defaultHandler);
        }
    }

    protected void m_247577_(Block block, LootTable.Builder builder) {
        super.m_247577_(block, builder);
        this.added.add(block);
    }

    protected abstract void addTables();

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    public static LootTable.Builder createSelfDropDispatchTable(Block p_252253_, LootItemCondition.Builder p_248764_, LootPoolEntryContainer.Builder<?> p_249146_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)p_252253_).m_79080_(p_248764_)).m_7170_(p_249146_)));
    }

    public static LootTable.Builder createSilkTouchDispatchTable(Block p_250203_, LootPoolEntryContainer.Builder<?> p_252089_) {
        return KiwiBlockLoot.createSelfDropDispatchTable(p_250203_, HAS_SILK_TOUCH, p_252089_);
    }

    public static LootTable.Builder createShearsDispatchTable(Block p_252195_, LootPoolEntryContainer.Builder<?> p_250102_) {
        return KiwiBlockLoot.createSelfDropDispatchTable(p_252195_, HAS_SHEARS, p_250102_);
    }

    public static LootTable.Builder createSilkTouchOrShearsDispatchTable(Block p_250539_, LootPoolEntryContainer.Builder<?> p_251459_) {
        return KiwiBlockLoot.createSelfDropDispatchTable(p_250539_, HAS_SHEARS_OR_SILK_TOUCH, p_251459_);
    }

    public static LootTable.Builder createSilkTouchOnlyTable(ItemLike p_252216_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(HAS_SILK_TOUCH).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_252216_)));
    }

    public static LootTable.Builder createShearsOnlyDrop(ItemLike p_250684_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_250684_)));
    }
}

