/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen.provider;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import snownee.kiwi.datagen.provider.TagsProviderHelper;
import snownee.kiwi.mixin.BlockAccess;

public abstract class KiwiBlockTagsProvider
extends BlockTagsProvider {
    protected final TagsProviderHelper<Block> helper = new TagsProviderHelper(this);

    public KiwiBlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, modId, existingFileHelper);
    }

    public void processTools(TagsProviderHelper.OptionalEntry<Block> entry) {
        this.processTools(entry, true);
    }

    public boolean processTools(TagsProviderHelper.OptionalEntry<Block> entry, boolean addParentInstead) {
        Block block = entry.object();
        Material material = ((BlockAccess)block).getMaterial();
        if (material == Material.f_76274_) {
            this.helper.add((TagKey<Block>)BlockTags.f_144281_, entry);
            return true;
        }
        if (material == Material.f_76320_ || material == Material.f_76321_) {
            if (addParentInstead) {
                if (block instanceof WallSignBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13067_, entry);
                    return true;
                }
                if (block instanceof StandingSignBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13066_, entry);
                    return true;
                }
                if (block instanceof ButtonBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13092_, entry);
                    return true;
                }
                if (block instanceof DoorBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13095_, entry);
                    return true;
                }
                if (block instanceof FenceBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13098_, entry);
                    return true;
                }
                if (block instanceof StairBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13096_, entry);
                    return true;
                }
                if (block instanceof SlabBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13097_, entry);
                    return true;
                }
                if (block instanceof PressurePlateBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13100_, entry);
                    return true;
                }
                if (block instanceof TrapDoorBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13102_, entry);
                    return true;
                }
            }
            this.helper.add((TagKey<Block>)BlockTags.f_144280_, entry);
        } else {
            if (material == Material.f_76300_ || material == Material.f_76302_ || material == Material.f_76285_) {
                if (addParentInstead && block instanceof SaplingBlock) {
                    this.helper.add((TagKey<Block>)BlockTags.f_13104_, entry);
                    return true;
                }
                this.helper.add((TagKey<Block>)BlockTags.f_144280_, entry);
                return true;
            }
            if (material == Material.f_76278_ || material == Material.f_76279_ || material == Material.f_76281_) {
                if (addParentInstead) {
                    if (block instanceof WallBlock) {
                        this.helper.add((TagKey<Block>)BlockTags.f_13032_, entry);
                        return true;
                    }
                    if (block instanceof BaseRailBlock) {
                        this.helper.add((TagKey<Block>)BlockTags.f_13034_, entry);
                        return true;
                    }
                }
                this.helper.add((TagKey<Block>)BlockTags.f_144282_, entry);
                return true;
            }
            if (material == Material.f_76317_ || material == Material.f_76313_ || material == Material.f_76314_ || material == Material.f_76280_) {
                this.helper.add((TagKey<Block>)BlockTags.f_144283_, entry);
                return true;
            }
        }
        return false;
    }

    public TagsProvider.TagAppender<Block> tag(String name) {
        return this.m_206424_(BlockTags.create((ResourceLocation)new ResourceLocation(this.modId, name)));
    }
}

