/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class PlayerAdvancements {
    private static final Logger f_135958_ = LogUtils.getLogger();
    private static final Gson f_135959_ = new GsonBuilder().registerTypeAdapter(AdvancementProgress.class, (Object)new AdvancementProgress.Serializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    private static final TypeToken<Map<ResourceLocation, AdvancementProgress>> f_135960_ = new TypeToken<Map<ResourceLocation, AdvancementProgress>>(){};
    private final DataFixer f_135961_;
    private final PlayerList f_135962_;
    private final Path f_263766_;
    private final Map<Advancement, AdvancementProgress> f_263740_ = new LinkedHashMap<Advancement, AdvancementProgress>();
    private final Set<Advancement> f_135965_ = new HashSet<Advancement>();
    private final Set<Advancement> f_135967_ = new HashSet<Advancement>();
    private final Set<Advancement> f_263821_ = new HashSet<Advancement>();
    private ServerPlayer f_135968_;
    @Nullable
    private Advancement f_135969_;
    private boolean f_135970_ = true;

    public PlayerAdvancements(DataFixer p_265655_, PlayerList p_265703_, ServerAdvancementManager p_265166_, Path p_265268_, ServerPlayer p_265673_) {
        this.f_135961_ = p_265655_;
        this.f_135962_ = p_265703_;
        this.f_263766_ = p_265268_;
        this.f_135968_ = p_265673_;
        this.m_136006_(p_265166_);
    }

    public void m_135979_(ServerPlayer p_135980_) {
        this.f_135968_ = p_135980_;
    }

    public void m_135978_() {
        for (CriterionTrigger<?> $$0 : CriteriaTriggers.m_10594_()) {
            $$0.m_5656_(this);
        }
    }

    public void m_135981_(ServerAdvancementManager p_135982_) {
        this.m_135978_();
        this.f_263740_.clear();
        this.f_135965_.clear();
        this.f_263821_.clear();
        this.f_135967_.clear();
        this.f_135970_ = true;
        this.f_135969_ = null;
        this.m_136006_(p_135982_);
    }

    private void m_135994_(ServerAdvancementManager p_135995_) {
        for (Advancement $$1 : p_135995_.m_136028_()) {
            this.m_136004_($$1);
        }
    }

    private void m_136002_(ServerAdvancementManager p_136003_) {
        for (Advancement $$1 : p_136003_.m_136028_()) {
            if (!$$1.m_138325_().isEmpty()) continue;
            this.m_135988_($$1, "");
            $$1.m_138321_().m_9989_(this.f_135968_);
        }
    }

    private void m_136006_(ServerAdvancementManager p_136007_) {
        if (Files.isRegularFile(this.f_263766_, new LinkOption[0])) {
            try (JsonReader $$1 = new JsonReader((Reader)Files.newBufferedReader(this.f_263766_, StandardCharsets.UTF_8));){
                $$1.setLenient(false);
                Dynamic $$2 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)$$1));
                int $$3 = $$2.get("DataVersion").asInt(1343);
                $$2 = $$2.remove("DataVersion");
                $$2 = DataFixTypes.ADVANCEMENTS.m_264140_(this.f_135961_, $$2, $$3);
                Map $$4 = (Map)f_135959_.getAdapter(f_135960_).fromJsonTree((JsonElement)$$2.getValue());
                if ($$4 == null) {
                    throw new JsonParseException("Found null for advancements");
                }
                $$4.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(p_265663_ -> {
                    Advancement $$2 = p_136007_.m_136041_((ResourceLocation)p_265663_.getKey());
                    if ($$2 == null) {
                        f_135958_.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", p_265663_.getKey(), (Object)this.f_263766_);
                        return;
                    }
                    this.m_135985_($$2, (AdvancementProgress)p_265663_.getValue());
                    this.f_135967_.add($$2);
                    this.m_264423_($$2);
                });
            }
            catch (JsonParseException $$5) {
                f_135958_.error("Couldn't parse player advancements in {}", (Object)this.f_263766_, (Object)$$5);
            }
            catch (IOException $$6) {
                f_135958_.error("Couldn't access player advancements in {}", (Object)this.f_263766_, (Object)$$6);
            }
        }
        this.m_136002_(p_136007_);
        this.m_135994_(p_136007_);
    }

    public void m_135991_() {
        LinkedHashMap<ResourceLocation, AdvancementProgress> $$0 = new LinkedHashMap<ResourceLocation, AdvancementProgress>();
        for (Map.Entry<Advancement, AdvancementProgress> $$1 : this.f_263740_.entrySet()) {
            AdvancementProgress $$2 = $$1.getValue();
            if (!$$2.m_8206_()) continue;
            $$0.put($$1.getKey().m_138327_(), $$2);
        }
        JsonElement $$3 = f_135959_.toJsonTree($$0);
        $$3.getAsJsonObject().addProperty("DataVersion", (Number)SharedConstants.m_183709_().m_183476_().m_193006_());
        try {
            FileUtil.m_257659_(this.f_263766_.getParent());
            try (BufferedWriter $$4 = Files.newBufferedWriter(this.f_263766_, StandardCharsets.UTF_8, new OpenOption[0]);){
                f_135959_.toJson($$3, (Appendable)$$4);
            }
        }
        catch (IOException $$5) {
            f_135958_.error("Couldn't save player advancements to {}", (Object)this.f_263766_, (Object)$$5);
        }
    }

    public boolean m_135988_(Advancement p_135989_, String p_135990_) {
        boolean $$2 = false;
        AdvancementProgress $$3 = this.m_135996_(p_135989_);
        boolean $$4 = $$3.m_8193_();
        if ($$3.m_8196_(p_135990_)) {
            this.m_136008_(p_135989_);
            this.f_135967_.add(p_135989_);
            $$2 = true;
            if (!$$4 && $$3.m_8193_()) {
                p_135989_.m_138321_().m_9989_(this.f_135968_);
                if (p_135989_.m_138320_() != null && p_135989_.m_138320_().m_14996_() && this.f_135968_.f_19853_.m_46469_().m_46207_(GameRules.f_46153_)) {
                    this.f_135962_.m_240416_(Component.m_237110_("chat.type.advancement." + p_135989_.m_138320_().m_14992_().m_15548_(), this.f_135968_.m_5446_(), p_135989_.m_138330_()), false);
                }
            }
        }
        if (!$$4 && $$3.m_8193_()) {
            this.m_264423_(p_135989_);
        }
        return $$2;
    }

    public boolean m_135998_(Advancement p_135999_, String p_136000_) {
        boolean $$2 = false;
        AdvancementProgress $$3 = this.m_135996_(p_135999_);
        boolean $$4 = $$3.m_8193_();
        if ($$3.m_8209_(p_136000_)) {
            this.m_136004_(p_135999_);
            this.f_135967_.add(p_135999_);
            $$2 = true;
        }
        if ($$4 && !$$3.m_8193_()) {
            this.m_264423_(p_135999_);
        }
        return $$2;
    }

    private void m_264423_(Advancement p_265528_) {
        this.f_263821_.add(p_265528_.m_264348_());
    }

    private void m_136004_(Advancement p_136005_) {
        AdvancementProgress $$1 = this.m_135996_(p_136005_);
        if ($$1.m_8193_()) {
            return;
        }
        for (Map.Entry<String, Criterion> $$2 : p_136005_.m_138325_().entrySet()) {
            CriterionTrigger<CriterionTriggerInstance> $$5;
            CriterionTriggerInstance $$4;
            CriterionProgress $$3 = $$1.m_8214_($$2.getKey());
            if ($$3 == null || $$3.m_12911_() || ($$4 = $$2.getValue().m_11416_()) == null || ($$5 = CriteriaTriggers.m_10597_($$4.m_7294_())) == null) continue;
            $$5.m_6467_(this, new CriterionTrigger.Listener<CriterionTriggerInstance>($$4, p_136005_, $$2.getKey()));
        }
    }

    private void m_136008_(Advancement p_136009_) {
        AdvancementProgress $$1 = this.m_135996_(p_136009_);
        for (Map.Entry<String, Criterion> $$2 : p_136009_.m_138325_().entrySet()) {
            CriterionTrigger<CriterionTriggerInstance> $$5;
            CriterionTriggerInstance $$4;
            CriterionProgress $$3 = $$1.m_8214_($$2.getKey());
            if ($$3 == null || !$$3.m_12911_() && !$$1.m_8193_() || ($$4 = $$2.getValue().m_11416_()) == null || ($$5 = CriteriaTriggers.m_10597_($$4.m_7294_())) == null) continue;
            $$5.m_6468_(this, new CriterionTrigger.Listener<CriterionTriggerInstance>($$4, p_136009_, $$2.getKey()));
        }
    }

    public void m_135992_(ServerPlayer p_135993_) {
        if (this.f_135970_ || !this.f_263821_.isEmpty() || !this.f_135967_.isEmpty()) {
            HashMap<ResourceLocation, AdvancementProgress> $$1 = new HashMap<ResourceLocation, AdvancementProgress>();
            HashSet<Advancement> $$2 = new HashSet<Advancement>();
            HashSet<ResourceLocation> $$3 = new HashSet<ResourceLocation>();
            for (Advancement $$4 : this.f_263821_) {
                this.m_264265_($$4, $$2, $$3);
            }
            this.f_263821_.clear();
            for (Advancement $$5 : this.f_135967_) {
                if (!this.f_135965_.contains($$5)) continue;
                $$1.put($$5.m_138327_(), this.f_263740_.get($$5));
            }
            this.f_135967_.clear();
            if (!($$1.isEmpty() && $$2.isEmpty() && $$3.isEmpty())) {
                p_135993_.f_8906_.m_9829_(new ClientboundUpdateAdvancementsPacket(this.f_135970_, $$2, $$3, $$1));
            }
        }
        this.f_135970_ = false;
    }

    public void m_135983_(@Nullable Advancement p_135984_) {
        Advancement $$1 = this.f_135969_;
        this.f_135969_ = p_135984_ != null && p_135984_.m_138319_() == null && p_135984_.m_138320_() != null ? p_135984_ : null;
        if ($$1 != this.f_135969_) {
            this.f_135968_.f_8906_.m_9829_(new ClientboundSelectAdvancementsTabPacket(this.f_135969_ == null ? null : this.f_135969_.m_138327_()));
        }
    }

    public AdvancementProgress m_135996_(Advancement p_135997_) {
        AdvancementProgress $$1 = this.f_263740_.get(p_135997_);
        if ($$1 == null) {
            $$1 = new AdvancementProgress();
            this.m_135985_(p_135997_, $$1);
        }
        return $$1;
    }

    private void m_135985_(Advancement p_135986_, AdvancementProgress p_135987_) {
        p_135987_.m_8198_(p_135986_.m_138325_(), p_135986_.m_138329_());
        this.f_263740_.put(p_135986_, p_135987_);
    }

    private void m_264265_(Advancement p_265158_, Set<Advancement> p_265206_, Set<ResourceLocation> p_265593_) {
        AdvancementVisibilityEvaluator.m_264099_(p_265158_, p_265787_ -> this.m_135996_((Advancement)p_265787_).m_8193_(), (p_265247_, p_265330_) -> {
            if (p_265330_) {
                if (this.f_135965_.add(p_265247_)) {
                    p_265206_.add(p_265247_);
                    if (this.f_263740_.containsKey(p_265247_)) {
                        this.f_135967_.add(p_265247_);
                    }
                }
            } else if (this.f_135965_.remove(p_265247_)) {
                p_265593_.add(p_265247_.m_138327_());
            }
        });
    }
}

