/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.networking.messages;

import com.elenai.elenaidodge2.client.ED2ClientStorage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncSTCPacket {
    private final boolean airborne;
    private final int cooldown;
    private final int cost;
    private final double power;
    private final double verticality;

    public ConfigSyncSTCPacket(boolean airborne, int cooldown, int cost, double power, double verticality) {
        this.airborne = airborne;
        this.cooldown = cooldown;
        this.cost = cost;
        this.power = power;
        this.verticality = verticality;
    }

    public ConfigSyncSTCPacket(FriendlyByteBuf buf) {
        this.airborne = buf.readBoolean();
        this.cooldown = buf.readInt();
        this.cost = buf.readInt();
        this.power = buf.readDouble();
        this.verticality = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.airborne);
        buf.writeInt(this.cooldown);
        buf.writeInt(this.cost);
        buf.writeDouble(this.power);
        buf.writeDouble(this.verticality);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ED2ClientStorage.setAirborne(this.airborne);
            ED2ClientStorage.setCooldown(this.cooldown);
            ED2ClientStorage.setCost(this.cost);
            ED2ClientStorage.setPower(this.power);
            ED2ClientStorage.setVerticality(this.verticality);
        });
        return true;
    }
}

