/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.mixin.accessors.client.WorldRendererAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHighlightEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class BlockOverlayUtils {
    private static final Vec2[] quarterRotationArrowCoords = new Vec2[]{new Vec2(0.375f, 0.0f), new Vec2(0.5f, -0.125f), new Vec2(0.4375f, -0.125f), new Vec2(0.4375f, -0.25f), new Vec2(0.25f, -0.4375f), new Vec2(0.0f, -0.4375f), new Vec2(0.0f, -0.3125f), new Vec2(0.1875f, -0.3125f), new Vec2(0.3125f, -0.1875f), new Vec2(0.3125f, -0.125f), new Vec2(0.25f, -0.125f)};
    private static final Vec2[] quarterRotationArrowQuads = new Vec2[]{quarterRotationArrowCoords[5], quarterRotationArrowCoords[6], quarterRotationArrowCoords[4], quarterRotationArrowCoords[7], quarterRotationArrowCoords[3], quarterRotationArrowCoords[8], quarterRotationArrowCoords[2], quarterRotationArrowCoords[9], quarterRotationArrowCoords[1], quarterRotationArrowCoords[10], quarterRotationArrowCoords[0], quarterRotationArrowCoords[0]};
    private static final Vec2[] halfRotationArrowCoords = new Vec2[]{new Vec2(0.375f, 0.0f), new Vec2(0.5f, -0.125f), new Vec2(0.4375f, -0.125f), new Vec2(0.4375f, -0.25f), new Vec2(0.25f, -0.4375f), new Vec2(-0.25f, -0.4375f), new Vec2(-0.4375f, -0.25f), new Vec2(-0.4375f, -0.0625f), new Vec2(-0.3125f, -0.0625f), new Vec2(-0.3125f, -0.1875f), new Vec2(-0.1875f, -0.3125f), new Vec2(0.1875f, -0.3125f), new Vec2(0.3125f, -0.1875f), new Vec2(0.3125f, -0.125f), new Vec2(0.25f, -0.125f)};
    private static final Vec2[] halfRotationArrowQuads = new Vec2[]{halfRotationArrowCoords[7], halfRotationArrowCoords[8], halfRotationArrowCoords[6], halfRotationArrowCoords[9], halfRotationArrowCoords[5], halfRotationArrowCoords[10], halfRotationArrowCoords[4], halfRotationArrowCoords[11], halfRotationArrowCoords[3], halfRotationArrowCoords[12], halfRotationArrowCoords[2], halfRotationArrowCoords[13], halfRotationArrowCoords[1], halfRotationArrowCoords[14], halfRotationArrowCoords[0], halfRotationArrowCoords[0]};
    private static final float[][] arrowCoords = new float[][]{{0.0f, 0.375f}, {0.3125f, 0.0625f}, {0.125f, 0.0625f}, {0.125f, -0.375f}, {-0.125f, -0.375f}, {-0.125f, 0.0625f}, {-0.3125f, 0.0625f}};

    public static void drawBlockOverlayText(PoseStack transform, Component[] text, int scaledWidth, int scaledHeight) {
        if (text != null && text.length > 0) {
            BlockOverlayUtils.drawBlockOverlayText(transform, Arrays.asList(text), scaledWidth, scaledHeight);
        }
    }

    public static void drawBlockOverlayText(PoseStack transform, Iterable<Component> text, int scaledWidth, int scaledHeight) {
        int i = 0;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (Component s : text) {
            if (s == null) continue;
            Font font = ClientUtils.font();
            FormattedCharSequence formattedCharSequence = Language.m_128107_().m_5536_((FormattedText)s);
            float f = scaledWidth / 2 + 8;
            int n = scaledHeight / 2 + 8;
            int n2 = i++;
            Objects.requireNonNull(ClientUtils.font());
            font.m_272191_(formattedCharSequence, f, (float)(n + n2 * 9), -1, true, transform.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        buffer.m_109911_();
    }

    public static void drawCircularRotationArrows(MultiBufferSource buffer, PoseStack transform, float rotation, boolean flip, boolean halfCircle) {
        int i;
        Matrix4f mat;
        int arrowId;
        int[] vertexOrder;
        Vec2[] rotationArrowQuads;
        Vec2[] rotationArrowCoords;
        transform.m_85836_();
        transform.m_85837_(0.0, 0.502, 0.0);
        if (halfCircle) {
            rotationArrowCoords = halfRotationArrowCoords;
            rotationArrowQuads = halfRotationArrowQuads;
        } else {
            rotationArrowCoords = quarterRotationArrowCoords;
            rotationArrowQuads = quarterRotationArrowQuads;
        }
        if (flip) {
            transform.m_252781_(new Quaternionf().rotateXYZ(0.0f, -rotation, 0.0f));
            transform.m_85841_(1.0f, 1.0f, -1.0f);
            vertexOrder = new int[]{2, 3, 1, 0};
        } else {
            transform.m_252781_(new Quaternionf().rotateXYZ(0.0f, rotation, 0.0f));
            vertexOrder = new int[]{0, 1, 3, 2};
        }
        transform.m_85836_();
        VertexConsumer builder = buffer.m_6299_(IERenderTypes.LINES);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.m_85850_().m_252922_();
            for (i = 0; i < rotationArrowCoords.length; ++i) {
                Vec2 here = rotationArrowCoords[i];
                Vec2 next = rotationArrowCoords[(i + 1) % rotationArrowCoords.length];
                Vec2 diff = new Vec2(next.f_82470_ - here.f_82470_, next.f_82471_ - here.f_82471_).m_165902_();
                for (Vec2 v : ImmutableList.of((Object)here, (Object)next)) {
                    builder.m_252986_(mat, v.f_82470_, 0.0f, v.f_82471_).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_252939_(transform.m_85850_().m_252943_(), diff.f_82470_, 0.0f, diff.f_82471_).m_5752_();
                }
            }
            transform.m_252781_(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f));
        }
        transform.m_85849_();
        transform.m_85836_();
        builder = buffer.m_6299_(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.m_85850_().m_252922_();
            i = 0;
            while (i + 3 < rotationArrowQuads.length) {
                for (int offset : vertexOrder) {
                    Vec2 p = rotationArrowQuads[i + offset];
                    builder.m_252986_(mat, p.f_82470_, 0.0f, p.f_82471_).m_85950_(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).m_5752_();
                }
                i += 2;
            }
            transform.m_252781_(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f));
        }
        transform.m_85849_();
        transform.m_85849_();
    }

    public static void drawBlockOverlayArrow(PoseStack.Pose transform, MultiBufferSource buffers, Vec3 directionVec, Direction side, AABB targetedBB) {
        Vec3[] translatedPositions = new Vec3[arrowCoords.length];
        Matrix4 mat = new Matrix4();
        Vec3 defaultDir = side.m_122434_() == Direction.Axis.Y ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 1.0, 0.0);
        directionVec = directionVec.m_82541_();
        double angle = Math.acos(defaultDir.m_82526_(directionVec));
        Vec3 axis = defaultDir.m_82537_(directionVec);
        mat.rotate(angle, axis.f_82479_, axis.f_82480_, axis.f_82481_);
        if (side.m_122434_() == Direction.Axis.Z) {
            mat.rotate(1.5707963267948966, 1.0, 0.0, 0.0).rotate(Math.PI, 0.0, 1.0, 0.0);
        } else if (side.m_122434_() == Direction.Axis.X) {
            mat.rotate(1.5707963267948966, 0.0, 0.0, 1.0).rotate(1.5707963267948966, 0.0, 1.0, 0.0);
        }
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3 vec = mat.apply(new Vec3((double)arrowCoords[i][0], 0.0, (double)arrowCoords[i][1])).m_82520_(0.5, 0.5, 0.5);
            if (targetedBB != null) {
                vec = new Vec3(side == Direction.WEST ? targetedBB.f_82288_ - 0.002 : (side == Direction.EAST ? targetedBB.f_82291_ + 0.002 : vec.f_82479_), side == Direction.DOWN ? targetedBB.f_82289_ - 0.002 : (side == Direction.UP ? targetedBB.f_82292_ + 0.002 : vec.f_82480_), side == Direction.NORTH ? targetedBB.f_82290_ - 0.002 : (side == Direction.SOUTH ? targetedBB.f_82293_ + 0.002 : vec.f_82481_));
            }
            translatedPositions[i] = vec;
        }
        VertexConsumer triBuilder = buffers.m_6299_(IERenderTypes.TRANSLUCENT_TRIANGLES);
        Vec3 center = translatedPositions[0];
        for (int i = 2; i < translatedPositions.length; ++i) {
            Vec3 point = translatedPositions[i];
            Vec3 prevPoint = translatedPositions[i - 1];
            for (Vec3 p : new Vec3[]{center, prevPoint, point}) {
                triBuilder.m_252986_(transform.m_252922_(), (float)p.f_82479_, (float)p.f_82480_, (float)p.f_82481_).m_85950_(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).m_5752_();
            }
        }
        VertexConsumer lineBuilder = buffers.m_6299_(IERenderTypes.LINES);
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3 point = translatedPositions[i];
            Vec3 next = translatedPositions[(i + 1) % translatedPositions.length];
            Vec3 diff = next.m_82546_(point).m_82541_();
            for (Vec3 p : ImmutableList.of((Object)point, (Object)next)) {
                lineBuilder.m_252986_(transform.m_252922_(), (float)p.f_82479_, (float)p.f_82480_, (float)p.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_252939_(transform.m_252943_(), (float)diff.f_82479_, (float)diff.f_82480_, (float)diff.f_82481_).m_5752_();
            }
        }
    }

    public static void drawAdditionalBlockbreak(RenderHighlightEvent.Block ev, Player player, Collection<BlockPos> blocks) {
        Vec3 renderView = ev.getCamera().m_90583_();
        for (BlockPos pos : blocks) {
            ((WorldRendererAccess)ev.getLevelRenderer()).callRenderHitOutline(ev.getPoseStack(), ev.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (Entity)player, renderView.f_82479_, renderView.f_82480_, renderView.f_82481_, pos, ClientUtils.mc().f_91073_.m_8055_(pos));
        }
        PoseStack transform = ev.getPoseStack();
        transform.m_85836_();
        transform.m_85837_(-renderView.f_82479_, -renderView.f_82480_, -renderView.f_82481_);
        MultiPlayerGameMode controllerMP = ClientUtils.mc().f_91072_;
        if (controllerMP.m_105296_()) {
            RenderUtils.drawBlockDamageTexture(transform, ev.getMultiBufferSource(), player.f_19853_, blocks);
        }
        transform.m_85849_();
    }

    public static void renderOreveinMapOverlays(PoseStack transform, ItemFrame frameEntity, HitResult rayTraceResult, int scaledWidth, int scaledHeight) {
        Level world;
        MapItemSavedData mapData;
        ItemStack frameItem;
        if (frameEntity != null && (frameItem = frameEntity.m_31822_()).m_41720_() == Items.f_42573_ && ItemNBTHelper.hasKey(frameItem, "Decorations", 9) && (mapData = MapItem.m_42853_((ItemStack)frameItem, (Level)(world = frameEntity.m_20193_()))) != null) {
            Font font = ClientUtils.font();
            int mapScale = 1 << mapData.f_77890_;
            float mapRotation = (float)(frameEntity.m_31823_() % 4) * 1.5708f;
            Vec3 hitVec = rayTraceResult.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)frameEntity.m_31748_()));
            Direction frameDir = frameEntity.m_6350_();
            double cursorH = 0.0;
            double cursorV = 0.0;
            switch (frameDir) {
                case DOWN: {
                    cursorH = hitVec.f_82479_;
                    cursorV = 1.0 - hitVec.f_82481_;
                    break;
                }
                case UP: {
                    cursorH = hitVec.f_82479_;
                    cursorV = hitVec.f_82481_;
                    break;
                }
                case NORTH: {
                    cursorH = 1.0 - hitVec.f_82479_;
                    cursorV = 1.0 - hitVec.f_82480_;
                    break;
                }
                case SOUTH: {
                    cursorH = hitVec.f_82479_;
                    cursorV = 1.0 - hitVec.f_82480_;
                    break;
                }
                case WEST: {
                    cursorH = hitVec.f_82481_;
                    cursorV = 1.0 - hitVec.f_82480_;
                    break;
                }
                case EAST: {
                    cursorH = 1.0 - hitVec.f_82481_;
                    cursorV = 1.0 - hitVec.f_82480_;
                }
            }
            cursorH *= 128.0;
            cursorV *= 128.0;
            ListTag minerals = null;
            double lastDist = Double.MAX_VALUE;
            ListTag nbttaglist = frameItem.m_41783_().m_128437_("Decorations", 10);
            for (Tag inbt : nbttaglist) {
                CompoundTag tagCompound = (CompoundTag)inbt;
                String id = tagCompound.m_128461_("id");
                if (!id.startsWith("ie:coresample_") || !tagCompound.m_128441_("minerals")) continue;
                double sampleX = tagCompound.m_128459_("x");
                double sampleZ = tagCompound.m_128459_("z");
                float f = (float)(sampleX - (double)mapData.f_256718_) / (float)mapScale;
                float f1 = (float)(sampleZ - (double)mapData.f_256789_) / (float)mapScale;
                byte b0 = (byte)((double)(f * 2.0f) + 0.5);
                byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
                Vec3 mapPos = new Vec3(0.0, (double)b1, (double)b0);
                mapPos = mapPos.m_82496_(mapRotation);
                double offsetH = mapPos.f_82481_ / 2.0 + 64.0;
                double dH = cursorH - offsetH;
                double offsetV = mapPos.f_82480_ / 2.0 + 64.0;
                double dV = cursorV - offsetV;
                double dist = dH * dH + dV * dV;
                if (!(dist < 10.0) || !(dist < lastDist)) continue;
                lastDist = dist;
                minerals = tagCompound.m_128437_("minerals", 8);
            }
            if (minerals != null) {
                for (int i = 0; i < minerals.size(); ++i) {
                    MineralMix mix = MineralMix.RECIPES.getById((Level)Minecraft.m_91087_().f_91073_, new ResourceLocation(minerals.m_128778_(i)));
                    if (mix == null) continue;
                    String string = I18n.m_118938_((String)mix.getTranslationKey(), (Object[])new Object[0]);
                    float f = scaledWidth / 2 + 8;
                    int n = scaledHeight / 2 + 8;
                    Objects.requireNonNull(font);
                    font.m_92750_(transform, string, f, (float)(n + i * 9), 0xFFFFFF);
                }
            }
        }
    }
}

