/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ItemOverlayUtils {
    public static VertexConsumer getHudElementsBuilder(MultiBufferSource.BufferSource buffer) {
        return buffer.m_6299_(IERenderTypes.getGui(ImmersiveEngineering.rl("textures/gui/hud_elements.png")));
    }

    public static void renderRevolverOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        NonNullList<ItemStack> bullets = ((IEItemInterfaces.IBulletContainer)equipped.m_41720_()).getBullets(equipped);
        if (bullets != null) {
            float cdMax;
            int cd;
            float cooldown;
            int bulletAmount = ((IEItemInterfaces.IBulletContainer)equipped.m_41720_()).getBulletCount(equipped);
            HumanoidArm side = ItemUtils.getLivingHand((LivingEntity)player, hand);
            boolean right = side == HumanoidArm.RIGHT;
            float dx = right ? (float)(scaledWidth - 32 - 48) : 48.0f;
            float dy = scaledHeight - 64;
            transform.m_85836_();
            transform.m_85836_();
            transform.m_252880_(dx, dy, 0.0f);
            transform.m_85841_(0.5f, 0.5f, 1.0f);
            RevolverScreen.drawExternalGUI(bullets, bulletAmount, transform);
            transform.m_85849_();
            if (equipped.m_41720_() instanceof RevolverItem && (cooldown = 1.0f - (float)(cd = ((RevolverItem)equipped.m_41720_()).getShootCooldown(equipped)) / (cdMax = (float)((RevolverItem)equipped.m_41720_()).getMaxShootCooldown(equipped))) > 0.0f) {
                transform.m_252880_((float)(scaledWidth / 2 + (right ? 1 : -6)), (float)(scaledHeight / 2 - 7), 0.0f);
                float h1 = (double)cooldown > 0.33 ? 0.5f : cooldown * 1.5f;
                float h2 = cooldown;
                float x2 = (double)cooldown < 0.75 ? 1.0f : 4.0f * (1.0f - cooldown);
                float uMin = (88.0f + (right ? 0.0f : 7.0f * x2)) / 256.0f;
                float uMax = (88.0f + (right ? 7.0f * x2 : 0.0f)) / 256.0f;
                float vMin1 = (112.0f + (right ? h1 : h2) * 15.0f) / 256.0f;
                float vMin2 = (112.0f + (right ? h2 : h1) * 15.0f) / 256.0f;
                VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
                Matrix4f mat = transform.m_85850_().m_252922_();
                builder.m_252986_(mat, (right ? 0.0f : 1.0f - x2) * 7.0f, 15.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, 0.49609375f).m_5752_();
                builder.m_252986_(mat, (right ? x2 : 1.0f) * 7.0f, 15.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, 0.49609375f).m_5752_();
                builder.m_252986_(mat, (right ? x2 : 1.0f) * 7.0f, (right ? h2 : h1) * 15.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMin2).m_5752_();
                builder.m_252986_(mat, (right ? 0.0f : 1.0f - x2) * 7.0f, (right ? h1 : h2) * 15.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMin1).m_5752_();
            }
            transform.m_85849_();
        }
    }

    public static void renderRailgunOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        int duration = 72000 - (player.m_6117_() && player.m_7655_() == hand ? player.m_21212_() : 0);
        RailgunItem cfr_ignored_0 = (RailgunItem)equipped.m_41720_();
        int chargeTime = RailgunItem.getChargeTime(equipped);
        int chargeLevel = duration < 72000 ? Math.min(99, (int)((float)duration / (float)chargeTime * 100.0f)) : 0;
        float scale = 1.5f;
        VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
        boolean boundLeft = player.m_5737_() == HumanoidArm.RIGHT == (hand == InteractionHand.OFF_HAND);
        float dx = boundLeft ? 24.0f : (float)(scaledWidth - 24 - 64);
        float dy = scaledHeight - 16;
        transform.m_85836_();
        transform.m_252880_(dx, dy, 0.0f);
        GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, -32.0f, 64.0f, 32.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.375f, 0.5f);
        ItemStack ammo = RailgunItem.findAmmo(equipped, player);
        if (!ammo.m_41619_()) {
            GuiHelper.renderItemWithOverlayIntoGUI((MultiBufferSource)buffer, transform, ammo, 6, -22, player.f_19853_);
        }
        transform.m_85837_(30.0, -27.5, 0.0);
        transform.m_85841_(scale, scale, 1.0f);
        String chargeTxt = chargeLevel < 10 ? "0 " + chargeLevel : chargeLevel / 10 + " " + chargeLevel % 10;
        ClientUtils.font().m_271703_(chargeTxt, 0.0f, 0.0f, -557004, true, transform.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        transform.m_85849_();
    }

    public static void renderFluidTankOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped, boolean renderFluidUse, BiConsumer<VertexConsumer, IFluidHandlerItem> additionalRender) {
        VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
        float dx = scaledWidth - 16;
        float dy = scaledHeight;
        transform.m_85836_();
        transform.m_252880_(dx, dy, 0.0f);
        int w = 31;
        int h = 62;
        float uMin = 0.69921875f;
        float uMax = 0.8203125f;
        float vMin = 0.03515625f;
        float vMax = 0.27734375f;
        GuiHelper.drawTexturedColoredRect(builder, transform, -24.0f, -68.0f, w, h, 1.0f, 1.0f, 1.0f, 1.0f, uMin, uMax, vMin, vMax);
        transform.m_252880_(-23.0f, -37.0f, 0.0f);
        LazyOptional handlerOpt = FluidUtil.getFluidHandler((ItemStack)equipped);
        handlerOpt.ifPresent(handler -> {
            int capacity = -1;
            if (handler.getTanks() > 0) {
                capacity = handler.getTankCapacity(0);
            }
            if (capacity > 0) {
                FluidStack fuel = handler.getFluidInTank(0);
                int amount = fuel.getAmount();
                if (renderFluidUse && player.m_6117_() && player.m_7655_() == hand) {
                    int use = player.m_21252_();
                    amount -= use * (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
                }
                float cap = capacity;
                float angle = 83.0f - (float)(166 * amount) / cap;
                transform.m_85836_();
                transform.m_252781_(new Quaternionf().rotateZ(angle * ((float)Math.PI / 180)));
                GuiHelper.drawTexturedColoredRect(builder, transform, 6.0f, -2.0f, 24.0f, 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.35546875f, 0.48046875f, 0.3125f, 0.33984375f);
                transform.m_85849_();
                transform.m_252880_(23.0f, 37.0f, 0.0f);
                additionalRender.accept(builder, (IFluidHandlerItem)handler);
            }
        });
        transform.m_85849_();
    }

    public static void renderDrillOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            GuiHelper.drawTexturedColoredRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
            ItemStack head = ((DrillItem)equipped.m_41720_()).getHead(equipped);
            if (!head.m_41619_()) {
                GuiHelper.renderItemWithOverlayIntoGUI((MultiBufferSource)buffer, transform, head, -51, -45, player.f_19853_);
            }
        });
    }

    public static void renderBuzzsawOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            GuiHelper.drawTexturedColoredRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
            ItemStack blade = ((BuzzsawItem)equipped.m_41720_()).getHead(equipped);
            if (!blade.m_41619_()) {
                GuiHelper.renderItemWithOverlayIntoGUI((MultiBufferSource)buffer, transform, blade, -51, -45, player.f_19853_);
            }
        });
    }

    public static void renderChemthrowerOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, true, (builder, handler) -> {
            GuiHelper.drawTexturedColoredRect(builder, transform, -41.0f, -73.0f, 53.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.03125f, 0.23828125f, 0.015625f, 0.296875f);
            boolean ignite = ChemthrowerItem.isIgniteEnable(equipped);
            GuiHelper.drawTexturedColoredRect(builder, transform, -32.0f, -43.0f, 12.0f, 12.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2578125f, 0.3046875f, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
            GuiHelper.drawTexturedColoredRect(builder, transform, -100.0f, -20.0f, 64.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.296875f, 0.359375f);
            FluidStack fuel = handler.getFluidInTank(0);
            if (!fuel.isEmpty()) {
                String name = ClientUtils.font().m_92854_((FormattedText)fuel.getDisplayName(), 50).getString().trim();
                ClientUtils.font().m_271703_(name, (float)(-68 - ClientUtils.font().m_92895_(name) / 2), -15.0f, 0, false, transform.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        });
    }

    public static void renderShieldOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        CompoundTag upgrades = ((IEShieldItem)equipped.m_41720_()).getUpgrades(equipped);
        if (!upgrades.m_128456_()) {
            float h;
            VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
            boolean boundLeft = player.m_5737_() == HumanoidArm.RIGHT == (hand == InteractionHand.OFF_HAND);
            float dx = boundLeft ? 16.0f : (float)(scaledWidth - 16 - 64);
            float dy = scaledHeight;
            transform.m_85836_();
            transform.m_252880_(dx, dy, 0.0f);
            GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, -22.0f, 64.0f, 22.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.6875f, 0.7734375f);
            if (upgrades.m_128471_("flash")) {
                GuiHelper.drawTexturedColoredRect(builder, transform, 11.0f, -38.0f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, 0.625f, 0.6875f);
                if (upgrades.m_128441_("flash_cooldown")) {
                    h = (float)upgrades.m_128451_("flash_cooldown") / 40.0f * 16.0f;
                    GuiHelper.drawTexturedColoredRect(builder, transform, 11.0f, -22.0f - h, 16.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, (214.0f - h) / 256.0f, 0.8359375f);
                }
            }
            if (upgrades.m_128471_("shock")) {
                GuiHelper.drawTexturedColoredRect(builder, transform, 40.0f, -38.0f, 12.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, 0.625f, 0.6875f);
                if (upgrades.m_128441_("shock_cooldown")) {
                    h = (float)upgrades.m_128451_("shock_cooldown") / 40.0f * 16.0f;
                    GuiHelper.drawTexturedColoredRect(builder, transform, 40.0f, -22.0f - h, 12.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, (214.0f - h) / 256.0f, 0.8359375f);
                }
            }
            transform.m_85849_();
        }
    }
}

