/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.gui.BlastFurnaceMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;

public class BlastFurnaceScreen
extends IEContainerScreen<BlastFurnaceMenu> {
    private static final ResourceLocation TEXTURE = BlastFurnaceScreen.makeTextureLocation("blast_furnace");

    public BlastFurnaceScreen(BlastFurnaceMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
    }

    public static void drawFlameAndArrow(Screen screen, ContainerData state, PoseStack transform, int leftPos, int topPos, int arrowXOffset) {
        if (FurnaceHandler.StateView.getLastBurnTime(state) > 0) {
            int h = (int)(12.0f * ((float)FurnaceHandler.StateView.getBurnTime(state) / (float)FurnaceHandler.StateView.getLastBurnTime(state)));
            Screen.m_93228_((PoseStack)transform, (int)(leftPos + 56), (int)(topPos + 37 + 12 - h), (int)179, (int)(13 - h), (int)9, (int)h);
        }
        if (FurnaceHandler.StateView.getMaxProcess(state) > 0) {
            int w = (int)(22.0f * (1.0f - (float)FurnaceHandler.StateView.getProcess(state) / (float)FurnaceHandler.StateView.getMaxProcess(state)));
            Screen.m_93228_((PoseStack)transform, (int)(leftPos + arrowXOffset), (int)(topPos + 35), (int)177, (int)14, (int)w, (int)16);
        }
    }

    @Override
    protected void drawBackgroundTexture(PoseStack transform) {
        BlastFurnaceScreen.m_93228_((PoseStack)transform, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)176, (int)this.f_97727_);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull PoseStack transform, float f, int mx, int my) {
        BlastFurnaceScreen.drawFlameAndArrow((Screen)this, ((BlastFurnaceMenu)this.f_97732_).state, transform, this.f_97735_, this.f_97736_, 76);
    }

    public static class Advanced
    extends BlastFurnaceScreen {
        public Advanced(BlastFurnaceMenu container, Inventory inventoryPlayer, Component title) {
            super(container, inventoryPlayer, title);
            this.f_97726_ = 210;
        }

        @Override
        protected void drawContainerBackgroundPre(@Nonnull PoseStack transform, float f, int mx, int my) {
            Advanced.m_93228_((PoseStack)transform, (int)(this.f_97735_ + 140), (int)(this.f_97736_ + 11), (int)176, (int)32, (int)70, (int)46);
            if (((BlastFurnaceMenu)this.f_97732_).leftHeater.get().booleanValue()) {
                Advanced.m_93228_((PoseStack)transform, (int)(this.f_97735_ + 182), (int)(this.f_97736_ + 27), (int)200, (int)22, (int)10, (int)10);
            }
            if (((BlastFurnaceMenu)this.f_97732_).rightHeater.get().booleanValue()) {
                Advanced.m_93228_((PoseStack)transform, (int)(this.f_97735_ + 182), (int)(this.f_97736_ + 39), (int)200, (int)22, (int)10, (int)10);
            }
            super.drawContainerBackgroundPre(transform, f, mx, my);
        }

        @Override
        protected void m_7027_(PoseStack transform, int x, int y) {
            String title = I18n.m_118938_((String)"gui.immersiveengineering.blast_furnace.preheaters", (Object[])new Object[0]);
            int w = this.f_96547_.m_92895_(title) / 2;
            this.f_96547_.m_92883_(transform, title, (float)(175 - w), 18.0f, 0xAEAEAE);
            this.f_96547_.m_92883_(transform, I18n.m_118938_((String)"gui.immersiveengineering.left", (Object[])new Object[0]), 154.0f, 28.0f, 0xAEAEAE);
            this.f_96547_.m_92883_(transform, I18n.m_118938_((String)"gui.immersiveengineering.right", (Object[])new Object[0]), 154.0f, 40.0f, 0xAEAEAE);
        }
    }
}

