/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.common.gui.SorterMenu;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Locale;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SorterScreen
extends IEContainerScreen<SorterMenu> {
    private static final ResourceLocation TEXTURE = SorterScreen.makeTextureLocation("sorter");

    public SorterScreen(SorterMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.f_97727_ = 244;
        this.f_97731_ = this.f_97727_ - 91;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull PoseStack transform, float f, int mx, int my) {
        for (int side = 0; side < 6; ++side) {
            int x = this.f_97735_ + 30 + side / 2 * 58;
            int y = this.f_97736_ + 44 + side % 2 * 76;
            String s = I18n.m_118938_((String)("desc.immersiveengineering.info.blockSide." + Direction.m_122376_((int)side).toString()), (Object[])new Object[0]).substring(0, 1);
            RenderSystem.m_69478_();
            ClientUtils.font().m_92750_(transform, s, (float)(x - ClientUtils.font().m_92895_(s) / 2), (float)y, -1429418804);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        for (int side = 0; side < 6; ++side) {
            for (FilterBit bit : FilterBit.values()) {
                int x = this.f_97735_ + 3 + side / 2 * 58 + bit.ordinal() * 18;
                int y = this.f_97736_ + 3 + side % 2 * 76;
                int sideFinal = side;
                GetterAndSetter<Integer> value = ((SorterMenu)this.f_97732_).filterMasks.get(side);
                ButtonSorter b = new ButtonSorter(x, y, bit, value::get, btn -> {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128405_("sideConfigVal", (Integer)value.get() ^ bit.mask());
                    tag.m_128405_("sideConfigId", sideFinal);
                    this.sendUpdateToServer(tag);
                    this.fullInit();
                });
                this.m_142416_((GuiEventListener)b);
            }
        }
    }

    public static enum FilterBit {
        TAG,
        NBT,
        DAMAGE;


        public String getTranslationKey() {
            return "desc.immersiveengineering.info.filter." + this.name().toLowerCase(Locale.ROOT);
        }

        public int mask() {
            return 1 << this.ordinal();
        }
    }

    public static class ButtonSorter
    extends Button
    implements ITooltipWidget {
        private final FilterBit type;
        private final IntSupplier state;

        public ButtonSorter(int x, int y, FilterBit type, IntSupplier state, Button.OnPress handler) {
            super(x, y, 18, 18, (Component)Component.m_237119_(), handler, f_252438_);
            this.type = type;
            this.state = state;
        }

        public void m_86412_(PoseStack transform, int mx, int my, float partialTicks) {
            if (this.f_93624_) {
                ClientUtils.bindTexture(TEXTURE);
                this.f_93622_ = mx >= this.m_252754_() && my >= this.m_252907_() && mx < this.m_252754_() + this.f_93618_ && my < this.m_252907_() + this.f_93619_;
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                boolean active = (this.state.getAsInt() & this.type.mask()) != 0;
                ButtonSorter.m_93228_((PoseStack)transform, (int)this.m_252754_(), (int)this.m_252907_(), (int)(176 + this.type.ordinal() * 18), (int)(active ? 3 : 21), (int)this.f_93618_, (int)this.f_93619_);
            }
        }

        @Override
        public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
            String[] split = I18n.m_118938_((String)this.type.getTranslationKey(), (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    tooltip.add((Component)Component.m_237113_((String)split[i]));
                    continue;
                }
                tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)split[i]), ChatFormatting.GRAY));
            }
        }
    }
}

