/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ShaderManualElement
extends SpecialManualElements {
    final ShaderRegistry.ShaderRegistryEntry shader;
    ItemStack shaderItem;
    ItemStack[] exampleItems;
    IngredientWithSize replicationCost;
    int example = 0;
    boolean unlocked;
    MutableComponent name;
    MutableComponent text;

    public ShaderManualElement(ManualInstance manual, ShaderRegistry.ShaderRegistryEntry shader) {
        super(manual);
        this.shader = shader;
    }

    @Override
    public int getPixelsTaken() {
        return 47;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
        LocalPlayer player = ManualUtils.mc().f_91074_;
        UUID uuid = player.m_20148_();
        this.unlocked = ShaderRegistry.receivedShaders.get((Object)uuid).contains(this.shader.getName());
        this.shaderItem = new ItemStack((ItemLike)ShaderRegistry.itemShader);
        this.shaderItem.m_41784_().m_128359_("shader_name", this.shader.getName().toString());
        this.replicationCost = this.shader.replicationCost.get();
        if (this.unlocked) {
            ArrayList list = new ArrayList();
            for (ItemStack is : ShaderRegistry.itemExamples) {
                ItemStack s = is.m_41777_();
                s.getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
                    wrapper.setShaderItem(this.shaderItem);
                    list.add(s);
                });
            }
            this.exampleItems = list.toArray(new ItemStack[0]);
            this.example = 0;
            if (this.exampleItems.length > 1) {
                buttons.add(new GuiButtonManualNavigation(gui, x + 50, y, 10, 16, 0, btn -> {
                    --this.example;
                    if (this.example < 0) {
                        this.example = this.exampleItems.length - 1;
                    }
                }));
                buttons.add(new GuiButtonManualNavigation(gui, x + 100, y, 10, 16, 1, btn -> {
                    this.example = (this.example + 1) % this.exampleItems.length;
                }));
            }
        } else {
            this.exampleItems = null;
        }
        this.name = TextUtils.applyFormat(this.shaderItem.m_41786_(), ChatFormatting.BOLD);
        MutableComponent textAssembly = Component.m_237113_((String)"");
        textAssembly.m_7220_((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.level"), ChatFormatting.BOLD));
        textAssembly.m_7220_((Component)Component.m_237115_((String)("desc.immersiveengineering.info.shader.rarity." + this.shader.rarity.name().toLowerCase(Locale.US))));
        if (this.unlocked) {
            String details;
            String set = this.shader.info_set == null || this.shader.info_set.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.set.%s", this.shader.info_set);
            String reference = this.shader.info_reference == null || this.shader.info_reference.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.reference.%s", this.shader.info_reference);
            String string = details = this.shader.info_details == null || this.shader.info_details.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.details.%s", this.shader.info_details);
            if (set != null) {
                textAssembly.m_130946_("\n").m_7220_((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.set"), ChatFormatting.BOLD)).m_130946_(" " + set);
            }
            if (reference != null) {
                textAssembly.m_130946_("\n").m_7220_((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.reference"), ChatFormatting.BOLD)).m_130946_("\n" + reference);
            }
            if (details != null) {
                textAssembly.m_130946_("\n").m_7220_((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.details"), ChatFormatting.BOLD)).m_130946_("\n" + details);
            }
            Object cost = Integer.toString(this.replicationCost.getCount());
            if (!IngredientUtils.hasPlayerIngredient((Player)ManualUtils.mc().f_91074_, this.replicationCost) && !ManualUtils.mc().f_91074_.m_150110_().f_35937_) {
                cost = ChatFormatting.RED + (String)cost;
            }
            buttons.add(new GuiButtonManual(gui, x + 50, y + 120, 70, 12, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"ie.manual.entry.shaderList.order", (Object[])new Object[0]) + " " + (String)cost + "x   ")).m_130940_(ChatFormatting.BOLD), btn -> {
                if (IngredientUtils.hasPlayerIngredient((Player)ManualUtils.mc().f_91074_, this.replicationCost) || ManualUtils.mc().f_91074_.m_150110_().f_35937_) {
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.SPAWN, this.shader.getName()));
                }
                gui.fullInit();
            }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
        } else {
            textAssembly.m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"ie.manual.entry.shaderList.noInfo"));
            if (player.m_150110_().f_35937_) {
                buttons.add(new GuiButtonManual(gui, x + 10, y + 120, 100, 16, (Component)Component.m_237115_((String)"ie.manual.entry.shaderList.unlock"), btn -> {
                    UUID playerId = ManualUtils.mc().f_91074_.m_20148_();
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.UNLOCK, this.shader.getName()));
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.shader.getName());
                    gui.fullInit();
                }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
            }
        }
        this.text = textAssembly;
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        Lighting.m_84931_();
        float scale = 2.0f;
        transform.m_85836_();
        transform.m_252880_((float)x, (float)y, 0.0f);
        transform.m_85841_(scale, scale, scale);
        boolean examples = this.exampleItems != null && this.exampleItems.length > 0;
        ManualUtils.renderItemStack(transform, this.shaderItem, (int)((float)(10 + (examples ? 0 : 34)) / scale), (int)(-8.0f / scale), false);
        if (examples && this.example >= 0 && this.example < this.exampleItems.length) {
            ManualUtils.renderItemStack(transform, this.exampleItems[this.example], (int)(63.0f / scale), (int)(-8.0f / scale), false);
        }
        transform.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
        if (this.unlocked) {
            ManualUtils.renderItemStack(transform, this.replicationCost.getRandomizedExampleStack(ManualUtils.mc().f_91074_.f_19797_), 102, 118, false);
        }
        Lighting.m_84930_();
        int w = this.manual.fontRenderer().m_92895_(this.name.getString());
        this.drawWrappedWithTransform(transform, (FormattedText)this.name, 60 - w / 2, 24);
        if (this.text != null && !this.text.getString().isEmpty()) {
            this.drawWrappedWithTransform(transform, (FormattedText)this.text, 0, 38);
        }
        transform.m_85849_();
    }

    private void drawWrappedWithTransform(PoseStack transform, FormattedText text, int x, int y) {
        for (FormattedCharSequence line : this.manual.fontRenderer().m_92923_(text, 120)) {
            this.manual.fontRenderer().m_92877_(transform, line, (float)x, (float)y, this.manual.getTextColour());
            Objects.requireNonNull(this.manual.fontRenderer());
            y += 9;
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public void recalculateCraftingRecipes() {
    }
}

