/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import org.joml.Vector4f;

public class IEShaderLayerCompositeTexture
extends AbstractTexture {
    private final ResourceLocation canvasTexture;
    private final ShaderLayer[] layers;

    public IEShaderLayerCompositeTexture(ResourceLocation canvasTexture, ShaderLayer[] layers) {
        this.canvasTexture = canvasTexture;
        this.layers = layers;
    }

    public void m_6704_(@Nonnull ResourceManager resourceManager) {
        this.m_117964_();
        Resource iresource = (Resource)resourceManager.m_213713_(this.canvasTexture).orElseThrow();
        try (InputStream imageStream = iresource.m_215507_();
             NativeImage originalImage = NativeImage.m_85058_((InputStream)imageStream);){
            int canvasWidth = originalImage.m_84982_();
            int canvasHeight = originalImage.m_85084_();
            NativeImage finalTexture = new NativeImage(canvasWidth, canvasHeight, true);
            for (int layer = 0; layer < 17 && layer < this.layers.length; ++layer) {
                Object texPath = this.layers[layer].getTexture().m_135815_();
                if (!((String)texPath).startsWith("textures/")) {
                    texPath = "textures/" + (String)texPath;
                }
                if (!((String)texPath).endsWith(".png")) {
                    texPath = (String)texPath + ".png";
                }
                String texture = this.layers[layer].getTexture().m_135827_() + ":" + (String)texPath;
                Vector4f colour = this.layers[layer].getColor();
                Resource iresource1 = (Resource)resourceManager.m_213713_(new ResourceLocation(texture)).orElseThrow();
                try (InputStream texStream = iresource1.m_215507_();
                     NativeImage texureImage = NativeImage.m_85058_((InputStream)texStream);){
                    float[] mod = new float[]{colour.x(), colour.y(), colour.z(), colour.w()};
                    if ((double)mod[3] < 0.2) {
                        mod[3] = mod[3] * 2.5f;
                    }
                    IntFunction<Integer> uInterpolate = uIn -> uIn;
                    IntFunction<Integer> vInterpolate = vIn -> vIn;
                    int bufImg2Size = Math.min(texureImage.m_84982_(), texureImage.m_85084_());
                    int uMin = 0;
                    int vMin = 0;
                    int uMax = canvasWidth;
                    int vMax = canvasHeight;
                    double[] texBounds = this.layers[layer].getTextureBounds();
                    if (texBounds != null) {
                        double uOffset = texBounds[0] * (double)canvasWidth;
                        double vOffset = texBounds[1] * (double)canvasHeight;
                        double uScale = (double)bufImg2Size / ((texBounds[2] - texBounds[0]) * (double)canvasWidth);
                        double vScale = (double)bufImg2Size / ((texBounds[3] - texBounds[1]) * (double)canvasHeight);
                        uInterpolate = uIn -> (int)Math.round(((double)uIn - uOffset) * uScale);
                        vInterpolate = vIn -> (int)Math.round(((double)vIn - vOffset) * vScale);
                        uMin = (int)uOffset;
                        vMin = (int)vOffset;
                        uMax = (int)(texBounds[2] * (double)canvasWidth);
                        vMax = (int)(texBounds[3] * (double)canvasHeight);
                    }
                    try {
                        for (int v = vMin; v < vMax; ++v) {
                            for (int u = uMin; u < uMax; ++u) {
                                int color;
                                int interU = uInterpolate.apply(u) % bufImg2Size;
                                int interV = vInterpolate.apply(v) % bufImg2Size;
                                int iRGB = texureImage.m_84985_(interU, interV);
                                float[] rgb = new float[]{(float)(iRGB & 0xFF) / 255.0f, (float)(iRGB >> 8 & 0xFF) / 255.0f, (float)(iRGB >> 16 & 0xFF) / 255.0f, (float)(iRGB >> 24 & 0xFF) / 255.0f};
                                if ((iRGB & 0xFF000000) == 0) continue;
                                int iNoise = originalImage.m_84985_(u, v);
                                float[] noise = new float[]{(float)(iNoise & 0xFF) / 255.0f, (float)(iNoise >> 8 & 0xFF) / 255.0f, (float)(iNoise >> 16 & 0xFF) / 255.0f, (float)(iNoise >> 24 & 0xFF) / 255.0f};
                                for (int m = 0; m < 4; ++m) {
                                    rgb[m] = rgb[m] * mod[m] * noise[m];
                                }
                                int[] irgb = new int[]{(int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), (int)(rgb[3] * 255.0f)};
                                int i2 = irgb[0] + (irgb[1] << 8) + (irgb[2] << 16) + (irgb[3] << 24);
                                int pre = finalTexture.m_84985_(u, v) >> 24 & 0xFF;
                                this.blendPixel(finalTexture, u, v, i2);
                                int post = finalTexture.m_84985_(u, v);
                                if (pre == 0) {
                                    color = irgb[3] << 24 | post & 0xFFFFFF;
                                    finalTexture.m_84988_(u, v, color);
                                    continue;
                                }
                                if ((post >> 24 & 0xFF) >= pre) continue;
                                color = pre << 24 | post & 0xFFFFFF;
                                finalTexture.m_84988_(u, v, color);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            TextureUtil.m_85287_((int)this.m_117963_(), (int)0, (int)finalTexture.m_84982_(), (int)finalTexture.m_85084_());
            finalTexture.m_85013_(0, 0, 0, 0, 0, finalTexture.m_84982_(), finalTexture.m_85084_(), false, false, false, false);
        }
        catch (IOException ioexception) {
            IELogger.error("Couldn't load layered image", ioexception);
        }
    }

    private void blendPixel(NativeImage image, int xIn, int yIn, int colIn) {
        int existing = image.m_84985_(xIn, yIn);
        float alphaIn = (float)FastColor.ARGB32.m_13655_((int)colIn) / 255.0f;
        float blueIn = (float)FastColor.ARGB32.m_13669_((int)colIn) / 255.0f;
        float greenIn = (float)FastColor.ARGB32.m_13667_((int)colIn) / 255.0f;
        float redIn = (float)FastColor.ARGB32.m_13665_((int)colIn) / 255.0f;
        float alphaOld = (float)FastColor.ARGB32.m_13655_((int)existing) / 255.0f;
        float blueOld = (float)FastColor.ARGB32.m_13669_((int)existing) / 255.0f;
        float greenOld = (float)FastColor.ARGB32.m_13667_((int)existing) / 255.0f;
        float redOld = (float)FastColor.ARGB32.m_13665_((int)existing) / 255.0f;
        float oldMixFactor = 1.0f - alphaIn;
        float alphaOut = alphaIn * alphaIn + alphaOld * oldMixFactor;
        float blueOut = blueIn * alphaIn + blueOld * oldMixFactor;
        float greenOut = greenIn * alphaIn + greenOld * oldMixFactor;
        float redOut = redIn * alphaIn + redOld * oldMixFactor;
        if (alphaOut > 1.0f) {
            alphaOut = 1.0f;
        }
        if (blueOut > 1.0f) {
            blueOut = 1.0f;
        }
        if (greenOut > 1.0f) {
            greenOut = 1.0f;
        }
        if (redOut > 1.0f) {
            redOut = 1.0f;
        }
        int redOutInt = (int)(alphaOut * 255.0f);
        int blueOutInt = (int)(blueOut * 255.0f);
        int greenOutInt = (int)(greenOut * 255.0f);
        int alphaOutInt = (int)(redOut * 255.0f);
        image.m_84988_(xIn, yIn, FastColor.ARGB32.m_13660_((int)redOutInt, (int)blueOutInt, (int)greenOutInt, (int)alphaOutInt));
    }
}

