/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.mixin.accessors.client.PlayerControllerAccess;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class RenderUtils {
    private static final Vector4f[] quadCoords = (Vector4f[])Util.m_137469_((Object)new Vector4f[4], a -> {
        for (int i = 0; i < ((Vector4f[])a).length; ++i) {
            a[i] = new Vector4f();
        }
    });
    private static final int[][] neighbourBrightness = new int[2][6];
    private static final float[][] normalizationFactors = new float[2][8];
    private static final VertexFormat FORMAT = DefaultVertexFormat.f_85811_;
    private static final int VERTEX_SIZE = FORMAT.m_86017_();
    private static final int UV_OFFSET = ClientUtils.findTextureOffset(FORMAT);
    private static final int POSITION_OFFSET = ClientUtils.findPositionOffset(FORMAT);

    public static void renderModelTESRFancy(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, Level world, BlockPos pos, boolean useCached, int color, int light) {
        if (((Boolean)IEClientConfig.disableFancyTESR.get()).booleanValue()) {
            RenderUtils.renderModelTESRFast(quads, renderer, transform, world.m_45524_(pos, 0), color);
        } else {
            if (!useCached) {
                for (Direction f : DirectionUtils.VALUES) {
                    int val = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos.m_121945_(f));
                    RenderUtils.neighbourBrightness[0][f.m_122411_()] = val >> 16 & 0xFF;
                    RenderUtils.neighbourBrightness[1][f.m_122411_()] = val & 0xFF;
                }
                for (int type = 0; type < 2; ++type) {
                    for (int i = 0; i < 8; ++i) {
                        float sSquared = 0.0f;
                        sSquared = (i & 1) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][5], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][4], 255.0f));
                        sSquared = (i & 2) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][1], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][0], 255.0f));
                        sSquared = (i & 4) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][3], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][2], 255.0f));
                        RenderUtils.normalizationFactors[type][i] = (float)Math.sqrt(sSquared);
                    }
                }
            }
            int[] rgba = new int[]{255, 255, 255, 255};
            if (color >= 0) {
                rgba[0] = color >> 16 & 0xFF;
                rgba[1] = color >> 8 & 0xFF;
                rgba[2] = color & 0xFF;
            }
            Matrix4f positionTransform = transform.m_85850_().m_252922_();
            Matrix3f normalTransform = transform.m_85850_().m_252943_();
            for (BakedQuad quad : quads) {
                int[] vData = quad.m_111303_();
                for (int i = 0; i < 4; ++i) {
                    quadCoords[i].set(Float.intBitsToFloat(vData[VERTEX_SIZE * i + POSITION_OFFSET]), Float.intBitsToFloat(vData[VERTEX_SIZE * i + POSITION_OFFSET + 1]), Float.intBitsToFloat(vData[VERTEX_SIZE * i + POSITION_OFFSET + 2]), 1.0f);
                }
                Vector3f normal = new Vector3f(RenderUtils.quadCoords[1].x, RenderUtils.quadCoords[1].y, RenderUtils.quadCoords[1].z);
                Vector3f side2 = new Vector3f(RenderUtils.quadCoords[2].x, RenderUtils.quadCoords[2].y, RenderUtils.quadCoords[2].z);
                normal.add(-quadCoords[3].x(), -quadCoords[3].y(), -quadCoords[3].z());
                side2.add(-quadCoords[0].x(), -quadCoords[0].y(), -quadCoords[0].z());
                normal.cross((Vector3fc)side2);
                normal.normalize();
                int l1 = RenderUtils.getLightValue(neighbourBrightness[1], normalizationFactors[1], light & 0xFF, normal);
                int l2 = RenderUtils.getLightValue(neighbourBrightness[0], normalizationFactors[0], light >> 16 & 0xFF, normal);
                normal.mul((Matrix3fc)normalTransform);
                for (int i = 0; i < 4; ++i) {
                    Vector4f vertexPos = quadCoords[i];
                    vertexPos.mul((Matrix4fc)positionTransform);
                    renderer.m_5954_(vertexPos.x(), vertexPos.y(), vertexPos.z(), (float)rgba[0] / 255.0f, (float)rgba[1] / 255.0f, (float)rgba[2] / 255.0f, (float)rgba[3] / 255.0f, Float.intBitsToFloat(vData[VERTEX_SIZE * i + UV_OFFSET]), Float.intBitsToFloat(vData[VERTEX_SIZE * i + UV_OFFSET + 1]), OverlayTexture.f_118083_, LightTexture.m_109885_((int)(l1 >> 4), (int)(l2 >> 4)), normal.x(), normal.y(), normal.z());
                }
            }
        }
    }

    private static int getLightValue(int[] neighbourBrightness, float[] normalizationFactors, int localBrightness, Vector3f normal) {
        double sideBrightness;
        byte type = 0;
        if (normal.x() > 0.0f) {
            sideBrightness = normal.x() * (float)neighbourBrightness[5];
            type = (byte)(type | 1);
        } else {
            sideBrightness = -normal.x() * (float)neighbourBrightness[4];
        }
        if (normal.y() > 0.0f) {
            sideBrightness += (double)(normal.y() * (float)neighbourBrightness[1]);
            type = (byte)(type | 2);
        } else {
            sideBrightness += (double)(-normal.y() * (float)neighbourBrightness[0]);
        }
        if (normal.z() > 0.0f) {
            sideBrightness += (double)(normal.z() * (float)neighbourBrightness[3]);
            type = (byte)(type | 4);
        } else {
            sideBrightness += (double)(-normal.z() * (float)neighbourBrightness[2]);
        }
        return (int)(((double)localBrightness + sideBrightness / (double)normalizationFactors[type]) / 2.0);
    }

    private static float scaledSquared(int val, float scale) {
        return (float)val / scale * ((float)val / scale);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, int light, int overlay) {
        RenderUtils.renderModelTESRFast(quads, renderer, transform, -1, light, overlay);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, int color, int light, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (color >= 0) {
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
        }
        for (BakedQuad quad : quads) {
            renderer.m_85987_(transform.m_85850_(), quad, red, green, blue, light, overlay);
        }
    }

    public static void drawBlockDamageTexture(PoseStack matrix, MultiBufferSource buffers, Level world, Collection<BlockPos> blocks) {
        MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
        int progress = (int)(((PlayerControllerAccess)controller).getDestroyProgress() * 10.0f) - 1;
        if (progress < 0 || progress >= ModelBakery.f_119229_.size()) {
            return;
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
        for (BlockPos blockpos : blocks) {
            BlockState iblockstate;
            boolean hasBreak;
            matrix.m_85836_();
            matrix.m_252880_((float)blockpos.m_123341_(), (float)blockpos.m_123342_(), (float)blockpos.m_123343_());
            VertexConsumer worldRendererIn = buffers.m_6299_((RenderType)ModelBakery.f_119229_.get(progress));
            worldRendererIn = new SheetedDecalTextureGenerator(worldRendererIn, matrix.m_85850_().m_252922_(), matrix.m_85850_().m_252943_(), 1.0f);
            Block block = world.m_8055_(blockpos).m_60734_();
            boolean bl = hasBreak = block instanceof ChestBlock || block instanceof EnderChestBlock || block instanceof SignBlock || block instanceof SkullBlock;
            if (!hasBreak && (iblockstate = world.m_8055_(blockpos)).m_60767_() != Material.f_76296_) {
                blockrendererdispatcher.m_110918_(iblockstate, blockpos, (BlockAndTintGetter)world, matrix, worldRendererIn);
            }
            matrix.m_85849_();
        }
    }

    public static void renderBox(VertexConsumer wr, PoseStack m, float x0, float y0, float z0, float x1, float y1, float z1) {
        Matrix4f transform = m.m_85850_().m_252922_();
        wr.m_252986_(transform, x0, y0, z1).m_5752_();
        wr.m_252986_(transform, x1, y0, z1).m_5752_();
        wr.m_252986_(transform, x1, y1, z1).m_5752_();
        wr.m_252986_(transform, x0, y1, z1).m_5752_();
        wr.m_252986_(transform, x0, y1, z0).m_5752_();
        wr.m_252986_(transform, x1, y1, z0).m_5752_();
        wr.m_252986_(transform, x1, y0, z0).m_5752_();
        wr.m_252986_(transform, x0, y0, z0).m_5752_();
        wr.m_252986_(transform, x0, y0, z0).m_5752_();
        wr.m_252986_(transform, x1, y0, z0).m_5752_();
        wr.m_252986_(transform, x1, y0, z1).m_5752_();
        wr.m_252986_(transform, x0, y0, z1).m_5752_();
        wr.m_252986_(transform, x0, y1, z1).m_5752_();
        wr.m_252986_(transform, x1, y1, z1).m_5752_();
        wr.m_252986_(transform, x1, y1, z0).m_5752_();
        wr.m_252986_(transform, x0, y1, z0).m_5752_();
        wr.m_252986_(transform, x0, y0, z0).m_5752_();
        wr.m_252986_(transform, x0, y0, z1).m_5752_();
        wr.m_252986_(transform, x0, y1, z1).m_5752_();
        wr.m_252986_(transform, x0, y1, z0).m_5752_();
        wr.m_252986_(transform, x1, y1, z0).m_5752_();
        wr.m_252986_(transform, x1, y1, z1).m_5752_();
        wr.m_252986_(transform, x1, y0, z1).m_5752_();
        wr.m_252986_(transform, x1, y0, z0).m_5752_();
    }

    public static void renderTexturedBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite tex, boolean yForV) {
        float minU = tex.m_118367_((double)(x0 * 16.0f));
        float maxU = tex.m_118367_((double)(x1 * 16.0f));
        float minV = tex.m_118393_((double)((yForV ? y1 : z0) * 16.0f));
        float maxV = tex.m_118393_((double)((yForV ? y0 : z1) * 16.0f));
        RenderUtils.renderTexturedBox(wr, stack, x0, y0, z0, x1, y1, z1, minU, minV, maxU, maxV, 0xF000F0);
    }

    public static void renderTexturedBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int light) {
        float normalX = 0.0f;
        float normalY = 0.0f;
        float normalZ = 1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u0, v1, normalX, normalY, normalZ, light);
        normalZ = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v1, normalX, normalY, normalZ, light);
        normalZ = 0.0f;
        normalY = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u0, v1, normalX, normalY, normalZ, light);
        normalY = 1.0f;
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ, light);
        normalY = 0.0f;
        normalX = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ, light);
        normalX = 1.0f;
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u0, v1, normalX, normalY, normalZ, light);
    }

    private static void putVertex(VertexConsumer b, PoseStack mat, float x, float y, float z, float u, float v, float nX, float nY, float nZ, int light) {
        b.m_252986_(mat.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat.m_85850_().m_252943_(), nX, nY, nZ).m_5752_();
    }
}

