/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ScheduledTick;

public class IEBaseBlock
extends Block
implements IIEBlock,
SimpleWaterloggedBlock {
    boolean isHidden;
    boolean hasFlavour;
    protected int lightOpacity;
    protected PushReaction mobilityFlag = PushReaction.NORMAL;
    protected final boolean notNormalBlock;
    private final boolean fitsIntoContainer;

    public IEBaseBlock(BlockBehaviour.Properties blockProps) {
        this(blockProps, true);
    }

    public IEBaseBlock(BlockBehaviour.Properties blockProps, boolean fitsIntoContainer) {
        super(blockProps);
        this.fitsIntoContainer = fitsIntoContainer;
        this.notNormalBlock = !this.m_49966_().m_60815_();
        this.m_49959_(this.getInitDefaultState());
        this.lightOpacity = -1;
    }

    public IEBaseBlock setHidden(boolean shouldHide) {
        this.isHidden = shouldHide;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public IEBaseBlock setHasFlavour(boolean shouldHave) {
        this.hasFlavour = shouldHave;
        return this;
    }

    @Override
    public String getNameForFlavour() {
        return BuiltInRegistries.f_256975_.m_7981_((Object)this).m_135815_();
    }

    @Override
    public boolean hasFlavour() {
        return this.hasFlavour;
    }

    public IEBaseBlock setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
        return this;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (this.lightOpacity != -1) {
            return this.lightOpacity;
        }
        if (this.notNormalBlock) {
            return 0;
        }
        return super.m_7753_(state, worldIn, pos);
    }

    public IEBaseBlock setMobility(PushReaction flag) {
        this.mobilityFlag = flag;
        return this;
    }

    public PushReaction m_5537_(BlockState state) {
        return this.mobilityFlag;
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return this.notNormalBlock ? 1.0f : super.m_7749_(state, world, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.notNormalBlock || super.m_7420_(state, reader, pos);
    }

    protected BlockState getInitDefaultState() {
        BlockState state = (BlockState)this.f_49792_.m_61090_();
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE);
        }
        return state;
    }

    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
    }

    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        return true;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public void fillCreativeTab(CreativeModeTab.Output out) {
        out.m_246326_((ItemLike)this);
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.f_46443_ && eventID == 255) {
            worldIn.m_7260_(pos, state, state, 3);
            return true;
        }
        return super.m_8133_(state, worldIn, pos, eventID, eventParam);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack activeStack = player.m_21120_(hand);
        if (activeStack.m_204117_(IETags.hammers)) {
            return this.hammerUseSide(hit.m_82434_(), player, hand, world, pos, hit);
        }
        if (activeStack.m_204117_(IETags.screwdrivers)) {
            return this.screwdriverUseSide(hit.m_82434_(), player, hand, world, pos, hit);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static BlockState applyLocationalWaterlogging(BlockState state, Level world, BlockPos pos) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        state = IEBaseBlock.applyLocationalWaterlogging(state, context.m_43725_(), context.m_8083_());
        return state;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            worldIn.m_183324_().m_183393_(new ScheduledTick((Object)Fluids.f_76193_, currentPos, (long)Fluids.f_76193_.m_6718_((LevelReader)worldIn), 0L));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return super.m_142598_(level, pos, state);
        }
        return ItemStack.f_41583_;
    }

    public boolean fitsIntoContainer() {
        return this.fitsIntoContainer;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.m_61143_(facingProp);
            Direction newDirection = rot.m_55954_(currentDirection);
            return (BlockState)state.m_61124_(facingProp, (Comparable)newDirection);
        }
        return super.m_6843_(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (state.m_61138_((Property)IEProperties.MIRRORED) && this.canRotate() && mirrorIn == Mirror.LEFT_RIGHT) {
            return (BlockState)state.m_61124_((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)IEProperties.MIRRORED) == false));
        }
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.m_61143_(facingProp);
            Direction newDirection = mirrorIn.m_54848_(currentDirection);
            return (BlockState)state.m_61124_(facingProp, (Comparable)newDirection);
        }
        return super.m_6943_(state, mirrorIn);
    }

    @Nullable
    private Property<Direction> findFacingProperty(BlockState state) {
        if (state.m_61138_((Property)IEProperties.FACING_ALL)) {
            return IEProperties.FACING_ALL;
        }
        if (state.m_61138_((Property)IEProperties.FACING_HORIZONTAL)) {
            return IEProperties.FACING_HORIZONTAL;
        }
        return null;
    }

    protected boolean canRotate() {
        return !this.m_49965_().m_61092_().contains(IEProperties.MULTIBLOCKSLAVE);
    }

    public static abstract class IELadderBlock
    extends IEBaseBlock {
        public IELadderBlock(BlockBehaviour.Properties material) {
            super(material);
        }

        public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, @Nullable LivingEntity entity) {
            return true;
        }

        public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
            super.m_7892_(state, worldIn, pos, entityIn);
            if (entityIn instanceof LivingEntity && this.isLadder(state, (LevelReader)worldIn, pos, (LivingEntity)entityIn)) {
                IELadderBlock.applyLadderLogic(entityIn);
            }
        }

        public static void applyLadderLogic(Entity entityIn) {
            if (entityIn instanceof LivingEntity && !((LivingEntity)entityIn).m_6147_()) {
                Vec3 motion = entityIn.m_20184_();
                float maxMotion = 0.15f;
                motion = new Vec3(Mth.m_14008_((double)motion.f_82479_, (double)(-maxMotion), (double)maxMotion), Math.max(motion.f_82480_, (double)(-maxMotion)), Mth.m_14008_((double)motion.f_82481_, (double)(-maxMotion), (double)maxMotion));
                entityIn.f_19789_ = 0.0f;
                if (motion.f_82480_ < 0.0 && entityIn instanceof Player && entityIn.m_6144_()) {
                    motion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_);
                } else if (entityIn.f_19862_) {
                    motion = new Vec3(motion.f_82479_, 0.2, motion.f_82481_);
                }
                entityIn.m_20256_(motion);
            }
        }
    }
}

