/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IEBlockInterfaces {

    public static interface IProcessBE {
        public int[] getCurrentProcessesStep();

        public int[] getCurrentProcessesMax();
    }

    public static interface IInteractionObjectIE<T extends BlockEntity>
    extends MenuProvider {
        @Nullable
        public T getGuiMaster();

        public IEMenuTypes.ArgContainer<? super T, ?> getContainerType();

        public boolean canUseGui(Player var1);

        default public boolean isValid() {
            return this.getGuiMaster() != null;
        }

        @Nonnull
        default public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
            T master = this.getGuiMaster();
            Preconditions.checkNotNull(master);
            IEMenuTypes.ArgContainer<T, ?> type = this.getContainerType();
            return type.create(id, playerInventory, master);
        }

        default public Component m_5446_() {
            return Component.m_237113_((String)"");
        }
    }

    public static interface IGeneralMultiblock
    extends BlockstateProvider {
        @Nullable
        public IGeneralMultiblock master();

        default public boolean isDummy() {
            BlockState state = this.getState();
            if (state.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE)) {
                return (Boolean)state.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE);
            }
            return true;
        }
    }

    public static interface IHasDummyBlocks
    extends IGeneralMultiblock {
        public void placeDummies(BlockPlaceContext var1, BlockState var2);

        public void breakDummies(BlockPos var1, BlockState var2);
    }

    public static interface ICollisionBounds {
        @Nonnull
        public VoxelShape getCollisionShape(CollisionContext var1);
    }

    public static interface ISelectionBounds {
        @Nonnull
        public VoxelShape getSelectionShape(@Nullable CollisionContext var1);
    }

    public static interface IBlockBounds
    extends ISelectionBounds,
    ICollisionBounds {
        @Nonnull
        public VoxelShape getBlockBounds(@Nullable CollisionContext var1);

        @Override
        @Nonnull
        default public VoxelShape getCollisionShape(CollisionContext ctx) {
            return this.getBlockBounds(ctx);
        }

        @Override
        @Nonnull
        default public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
            return this.getBlockBounds(ctx);
        }
    }

    public static interface IMirrorAble
    extends BlockstateProvider {
        default public boolean getIsMirrored() {
            BlockState state = this.getState();
            if (state.m_61138_((Property)IEProperties.MIRRORED)) {
                return (Boolean)state.m_61143_((Property)IEProperties.MIRRORED);
            }
            return false;
        }

        default public void setMirrored(boolean mirrored) {
            BlockState state = this.getState();
            BlockState newState = (BlockState)state.m_61124_((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored));
            this.setState(newState);
        }
    }

    public static interface IActiveState
    extends BlockstateProvider {
        default public boolean getIsActive() {
            BlockState state = this.getState();
            if (state.m_61138_((Property)IEProperties.ACTIVE)) {
                return (Boolean)state.m_61143_((Property)IEProperties.ACTIVE);
            }
            return false;
        }

        default public void setActive(boolean active) {
            BlockState state = this.getState();
            BlockState newState = (BlockState)state.m_61124_((Property)IEProperties.ACTIVE, (Comparable)Boolean.valueOf(active));
            this.setState(newState);
        }
    }

    public static interface IPlacementInteraction {
        public void onBEPlaced(BlockPlaceContext var1);
    }

    public static interface IScrewdriverInteraction {
        public InteractionResult screwdriverUseSide(Direction var1, Player var2, InteractionHand var3, Vec3 var4);
    }

    public static interface IHammerInteraction {
        public boolean hammerUseSide(Direction var1, Player var2, InteractionHand var3, Vec3 var4);
    }

    public static interface IPlayerInteraction {
        public boolean interact(Direction var1, Player var2, InteractionHand var3, ItemStack var4, float var5, float var6, float var7);
    }

    public static interface IEntityProof {
        public boolean canEntityDestroy(Entity var1);
    }

    public static interface IAdditionalDrops {
        public Collection<ItemStack> getExtraDrops(Player var1, BlockState var2);
    }

    public static interface IBlockEntityDrop
    extends IPlacementInteraction {
        public List<ItemStack> getBlockEntityDrop(LootContext var1);

        default public ItemStack getPickBlock(@Nullable Player player, BlockState state, HitResult rayRes) {
            BlockEntity tile = (BlockEntity)this;
            Level level = tile.m_58904_();
            if (!(level instanceof ServerLevel)) {
                return new ItemStack((ItemLike)state.m_60734_());
            }
            ServerLevel world = (ServerLevel)level;
            return this.getBlockEntityDrop(new LootContext.Builder(world).m_78984_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81461_, (Object)world.m_8055_(tile.m_58899_())).m_78984_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)tile.m_58899_())).m_78975_(LootContextParamSets.f_81421_)).get(0);
        }
    }

    public static interface IConfigurableSides {
        public IEEnums.IOSideConfig getSideConfig(Direction var1);

        public boolean toggleSide(Direction var1, Player var2);
    }

    public static interface IAdvancedDirectionalBE
    extends IDirectionalBE {
        public void onDirectionalPlacement(Direction var1, float var2, float var3, float var4, LivingEntity var5);
    }

    public static interface IStateBasedDirectional
    extends IDirectionalBE,
    BlockstateProvider {
        public Property<Direction> getFacingProperty();

        @Override
        default public Direction getFacing() {
            BlockState state = this.getState();
            if (state.m_61138_(this.getFacingProperty())) {
                return (Direction)state.m_61143_(this.getFacingProperty());
            }
            return Direction.NORTH;
        }

        @Override
        default public void setFacing(Direction facing) {
            BlockState oldState = this.getState();
            BlockState newState = (BlockState)oldState.m_61124_(this.getFacingProperty(), (Comparable)facing);
            this.setState(newState);
        }
    }

    public static interface BlockstateProvider {
        public BlockState getState();

        public void setState(BlockState var1);
    }

    public static interface IDirectionalBE {
        public Direction getFacing();

        public void setFacing(Direction var1);

        public PlacementLimitation getFacingLimitation();

        default public Direction getFacingForPlacement(BlockPlaceContext ctx) {
            Direction f = this.getFacingLimitation().getDirectionForPlacement(ctx);
            return this.mirrorFacingOnPlacement((LivingEntity)ctx.m_43723_()) ? f.m_122424_() : f;
        }

        default public boolean mirrorFacingOnPlacement(LivingEntity placer) {
            return false;
        }

        default public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
            return true;
        }

        default public void afterRotation(Direction oldDir, Direction newDir) {
        }
    }

    public static interface IColouredBE {
        public int getRenderColour(int var1);
    }

    public static interface IColouredBlock {
        public boolean hasCustomBlockColours();

        public int getRenderColour(BlockState var1, @Nullable BlockGetter var2, @Nullable BlockPos var3, int var4);
    }

    public static interface IRedstoneOutput {
        default public int getWeakRSOutput(Direction side) {
            return this.getStrongRSOutput(side);
        }

        public int getStrongRSOutput(Direction var1);

        public boolean canConnectRedstone(Direction var1);
    }

    public static interface IComparatorOverride {
        public int getComparatorInputOverride();
    }

    public static interface ISpawnInterdiction {
        public double getInterdictionRangeSquared();
    }

    public static interface ISoundBE {
        public boolean shouldPlaySound(String var1);

        default public float getSoundRadiusSq() {
            return 256.0f;
        }
    }

    public static interface IBlockOverlayText {
        @Nullable
        public Component[] getOverlayText(Player var1, HitResult var2, boolean var3);

        @Deprecated
        public boolean useNixieFont(Player var1, HitResult var2);
    }
}

