/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FeedthroughBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IStateBasedDirectional {
    public static final String WIRE = "wire";
    private static final String OFFSET = "offset";
    public static final String MIDDLE_STATE = "middle";
    @Nonnull
    public WireType reference = WireType.COPPER;
    @Nonnull
    public BlockState stateForMiddle = Blocks.f_50493_.m_49966_();
    public int offset = 0;
    public boolean currentlyDisassembling = false;
    private VoxelShape aabb;

    public FeedthroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FEEDTHROUGH.get(), pos, state);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128359_(WIRE, this.reference.getUniqueName());
        nbt.m_128405_(OFFSET, this.offset);
        CompoundTag stateNbt = NbtUtils.m_129202_((BlockState)this.stateForMiddle);
        nbt.m_128365_(MIDDLE_STATE, (Tag)stateNbt);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.reference = WireType.getValue(nbt.m_128461_(WIRE));
        this.offset = nbt.m_128451_(OFFSET);
        HolderLookup.RegistryLookup lookup = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        this.stateForMiddle = NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)nbt.m_128469_(MIDDLE_STATE));
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        double l = WireApi.INFOS.get(this.reference).connOffset();
        int factor = here.equals(this.getPositivePoint()) ? 1 : -1;
        return new Vec3(0.5 + (0.5 + l) * (double)this.getFacing().m_122429_() * (double)factor, 0.5 + (0.5 + l) * (double)this.getFacing().m_122430_() * (double)factor, 0.5 + (0.5 + l) * (double)this.getFacing().m_122431_() * (double)factor);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (!WireApi.canMix(this.reference, cableType)) {
            return false;
        }
        Collection<Connection> existing = this.globalNet.getLocalNet(target).getConnections(target);
        for (Connection c : existing) {
            if (c.isInternal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.f_58858_.m_5484_(this.getFacing(), 1), (Object)this.f_58858_.m_5484_(this.getFacing(), -1));
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.f_58858_.m_5484_(this.getFacing(), -this.offset);
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(this.reference);
        if (this.offset == 0) {
            LootContext.Builder builder = new LootContext.Builder(context.m_78952_()).m_78984_(LootContextParams.f_81463_, (Object)((ItemStack)context.m_78953_(LootContextParams.f_81463_))).m_78984_(LootContextParams.f_81455_, (Object)((Entity)context.m_78953_(LootContextParams.f_81455_))).m_78984_(LootContextParams.f_81460_, (Object)((Vec3)context.m_78953_(LootContextParams.f_81460_)));
            return Utils.getDrops(this.stateForMiddle, builder);
        }
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{new ItemStack((ItemLike)info.connector().m_60734_(), 1)});
    }

    @Override
    public ItemStack getPickBlock(@Nullable Player player, BlockState state, HitResult rayRes) {
        if (this.offset == 0) {
            return Utils.getPickBlock(this.stateForMiddle, rayRes, player);
        }
        return IEBlockInterfaces.IBlockEntityDrop.super.getPickBlock(player, state, rayRes);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        this.reference = WireType.getValue(ItemNBTHelper.getString(stack, WIRE));
        this.stateForMiddle = NbtUtils.m_247651_((HolderGetter)this.getLevelNonnull().m_246945_(Registries.f_256747_), (CompoundTag)ItemNBTHelper.getTagCompound(stack, MIDDLE_STATE));
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (this.offset == 0) {
            return Shapes.m_83144_();
        }
        if (this.aabb == null) {
            this.aabb = EnergyConnectorBlockEntity.getConnectorBounds(this.offset < 0 ? this.getFacing() : this.getFacing().m_122424_(), (float)WireApi.INFOS.get(this.reference).connLength());
        }
        return this.aabb;
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 253) {
            this.checkLight();
            return true;
        }
        return super.m_7531_(id, arg);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)this.getNegativePoint(), (Object)this.getPositivePoint());
    }

    public ConnectionPoint getNegativePoint() {
        return new ConnectionPoint(this.f_58858_, FeedthroughBlockEntity.getIndexForOffset(-1));
    }

    public ConnectionPoint getPositivePoint() {
        return new ConnectionPoint(this.f_58858_, FeedthroughBlockEntity.getIndexForOffset(1));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of((Object)new Connection(this.f_58858_, 0, 1));
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        if (offset.equals((Object)this.getFacing().m_122436_())) {
            return this.getPositivePoint();
        }
        if (offset.equals((Object)this.getFacing().m_122424_().m_122436_())) {
            return this.getNegativePoint();
        }
        return null;
    }

    public static int getIndexForOffset(int offset) {
        if (offset == -1) {
            return 1;
        }
        if (offset == 1) {
            return 0;
        }
        return -1;
    }

    public record FeedthroughData(BlockState baseState, WireType wire, Direction facing, int offset, int colorMultiplier) {
    }
}

