/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RazorWireBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ICollisionBounds,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.ISelectionBounds {
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES = new CachedVoxelShapes<BoundingBoxKey>(RazorWireBlockEntity::getShape);

    public RazorWireBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.RAZOR_WIRE.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (entity instanceof LivingEntity) {
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.m_7096_() / 5.0, motion.m_7098_(), motion.m_7094_() / 5.0);
            RazorWireBlockEntity.applyDamage((LivingEntity)entity);
        }
    }

    public static void applyDamage(LivingEntity entity) {
        int protection = (!entity.m_6844_(EquipmentSlot.FEET).m_41619_() ? 1 : 0) + (!entity.m_6844_(EquipmentSlot.LEGS).m_41619_() ? 1 : 0);
        float dmg = protection == 2 ? 0.5f : (protection == 1 ? 1.0f : 1.5f);
        entity.m_6469_(IEDamageSources.razorWire(entity.f_19853_), dmg);
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(this));
    }

    private static List<AABB> getShape(BoundingBoxKey key) {
        if (!key.onGround && !key.stacked || !key.wallL && !key.wallR) {
            return ImmutableList.of();
        }
        ArrayList<AABB> list = new ArrayList<AABB>(key.wallL && key.wallR ? 2 : 1);
        if (key.wallL) {
            list.add(new AABB(key.facing == Direction.SOUTH ? 0.8125 : 0.0, 0.0, key.facing == Direction.WEST ? 0.8125 : 0.0, key.facing == Direction.NORTH ? 0.1875 : 1.0, 1.0, key.facing == Direction.EAST ? 0.1875 : 1.0));
        }
        if (key.wallR) {
            list.add(new AABB(key.facing == Direction.NORTH ? 0.8125 : 0.0, 0.0, key.facing == Direction.EAST ? 0.8125 : 0.0, key.facing == Direction.SOUTH ? 0.1875 : 1.0, 1.0, key.facing == Direction.WEST ? 0.1875 : 1.0));
        }
        return list;
    }

    public boolean renderWall(boolean left) {
        Direction dir = left ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
        BlockPos neighbourPos = this.m_58899_().m_5484_(dir, -1);
        if (!this.f_58857_.m_46805_(neighbourPos)) {
            return true;
        }
        if (this.f_58857_.m_7702_(neighbourPos) instanceof RazorWireBlockEntity) {
            return false;
        }
        BlockState neighbour = this.f_58857_.m_8055_(neighbourPos);
        return !Block.m_49918_((VoxelShape)neighbour.m_60808_((BlockGetter)this.f_58857_, neighbourPos), (Direction)dir);
    }

    public boolean isOnGround() {
        BlockPos down = this.m_58899_().m_7495_();
        return Block.m_49918_((VoxelShape)this.f_58857_.m_8055_(down).m_60808_((BlockGetter)this.f_58857_, down), (Direction)Direction.UP);
    }

    public boolean isStacked() {
        BlockPos down = this.m_58899_().m_7495_();
        BlockEntity te = this.f_58857_.m_7702_(down);
        if (te instanceof RazorWireBlockEntity) {
            RazorWireBlockEntity razorWire = (RazorWireBlockEntity)te;
            return razorWire.isOnGround();
        }
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        boolean wallN;
        BlockPos otherPos = other.position();
        int xDif = otherPos.m_123341_() - this.f_58858_.m_123341_();
        int yDif = otherPos.m_123342_() - this.f_58858_.m_123342_();
        int zDif = otherPos.m_123343_() - this.f_58858_.m_123343_();
        boolean wallL = this.renderWall(true);
        boolean wallR = this.renderWall(false);
        if (!this.isOnGround() || !wallL && !wallR) {
            if (yDif > 0) {
                return new Vec3(this.getFacing().m_122429_() != 0 ? 0.5 : (xDif < 0 ? 0.40625 : 0.59375), 0.9375, this.getFacing().m_122431_() != 0 ? 0.5 : (zDif < 0 ? 0.40625 : 0.59375));
            }
            boolean right = (float)this.getFacing().m_122427_().m_122421_().m_122540_() == Math.copySign(1.0f, this.getFacing().m_122429_() != 0 ? (float)zDif : (float)xDif);
            int faceX = this.getFacing().m_122429_();
            int faceZ = this.getFacing().m_122431_();
            return new Vec3(faceX != 0 ? 0.5 + (right ? 0.0 : (double)faceX * 0.1875) : (double)(xDif >= 0 ? 1 : 0), 0.046875, faceZ != 0 ? 0.5 + (right ? 0.0 : (double)faceZ * 0.1875) : (double)(zDif >= 0 ? 1 : 0));
        }
        boolean bl = wallN = this.getFacing() == Direction.NORTH || this.getFacing() == Direction.EAST ? wallL : wallR;
        return new Vec3(this.getFacing().m_122429_() != 0 ? 0.5 : (xDif < 0 && wallN ? 0.125 : 0.875), 0.9375, this.getFacing().m_122431_() != 0 ? 0.5 : (zDif < 0 && wallN ? 0.125 : 0.875));
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        return 64;
    }

    @Override
    public void insertEnergy(int amount) {
        int maxReach = amount / 8;
        int widthP = 0;
        boolean connectP = true;
        int widthN = 0;
        boolean connectN = true;
        Direction dir = this.getFacing().m_122427_();
        if (dir.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            dir = dir.m_122424_();
        }
        for (int i = 1; i <= maxReach; ++i) {
            BlockPos posP = this.m_58899_().m_5484_(dir, i);
            if (connectP && this.f_58857_.m_46805_(posP) && this.f_58857_.m_7702_(posP) instanceof RazorWireBlockEntity) {
                ++widthP;
            } else {
                connectP = false;
            }
            BlockPos posN = this.m_58899_().m_5484_(dir, -i);
            if (connectN && this.f_58857_.m_46805_(posN) && this.f_58857_.m_7702_(posN) instanceof RazorWireBlockEntity) {
                ++widthN;
                continue;
            }
            connectN = false;
        }
        AABB aabb = new AABB(this.m_58899_().m_7918_(this.getFacing().m_122434_() == Direction.Axis.Z ? -widthN : 0, 0, this.getFacing().m_122434_() == Direction.Axis.X ? -widthN : 0), this.m_58899_().m_7918_(this.getFacing().m_122434_() == Direction.Axis.Z ? 1 + widthP : 1, 1, this.getFacing().m_122434_() == Direction.Axis.X ? 1 + widthP : 1));
        List entities = this.f_58857_.m_45976_(LivingEntity.class, aabb);
        for (LivingEntity ent : entities) {
            ent.m_6469_(IEDamageSources.razorShock(this.f_58857_), 2.0f);
        }
    }

    private static class BoundingBoxKey {
        public final boolean wallL;
        public final boolean wallR;
        public final boolean onGround;
        public final boolean stacked;
        public final Direction facing;

        public BoundingBoxKey(RazorWireBlockEntity te) {
            this.facing = te.getFacing();
            this.wallL = te.renderWall(true);
            this.wallR = te.renderWall(false);
            this.onGround = te.isOnGround();
            this.stacked = te.isStacked();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.wallL == that.wallL && this.wallR == that.wallR && this.onGround == that.onGround && this.stacked == that.stacked && this.facing == that.facing;
        }

        public int hashCode() {
            return Objects.hash(this.wallL, this.wallR, this.onGround, this.stacked, this.facing);
        }
    }
}

