/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.DirectProcessingItemHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.CrusherShapes;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class CrusherLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos MASTER_OFFSET = new BlockPos(2, 1, 1);
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 2);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(2, 0, 3, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(4, 1, 1, RelativeBlockFace.UP);
    private static final Vec3[] PARTICLE_POSITIONS = new Vec3[]{new Vec3(2.0, 2.125, 1.5), new Vec3(2.5, 2.125, 1.5), new Vec3(3.0, 2.125, 1.5)};

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean wasActive = state.renderAsActive;
        state.renderAsActive = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (wasActive != state.renderAsActive) {
            context.requestMasterBESync();
        }
        if (state.renderAsActive) {
            this.spawnParticles(context.getLevel(), state);
        }
    }

    public void spawnParticles(IMultiblockLevel level, State state) {
        MultiblockProcessInWorld inWorld;
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level2;
                if (state.processor.getQueueSize() == 0 || !((level2 = level.getRawLevel()) instanceof ServerLevel)) {
                    return;
                }
                serverLevel = (ServerLevel)level2;
                MultiblockProcess<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>> particleProcess = state.processor.getQueue().get(0);
                if (!(particleProcess instanceof MultiblockProcessInWorld)) break block5;
                inWorld = (MultiblockProcessInWorld)particleProcess;
                if (!inWorld.inputItems.isEmpty()) break block6;
            }
            return;
        }
        ItemStack particleStack = (ItemStack)inWorld.inputItems.get(0);
        ItemParticleOption particleData = new ItemParticleOption(ParticleTypes.f_123752_, particleStack);
        for (Vec3 relativeOffset : PARTICLE_POSITIONS) {
            Vec3 absolutePos = level.toAbsolute(relativeOffset);
            serverLevel.m_8767_((ParticleOptions)particleData, absolutePos.f_82479_, absolutePos.f_82480_, absolutePos.f_82481_, 8, 0.0, 0.0, 0.0, 0.0625);
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.renderAsActive) {
            state.barrelAngle = (state.barrelAngle + 18.0f) % 360.0f;
        }
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(2.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.renderAsActive, context.isValid(), soundPos, IESounds.crusher);
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        if (cap == ForgeCapabilities.ITEM_HANDLER && CrusherLogic.isInInput(position.posInMultiblock(), false)) {
            return state.insertionHandler.cast(ctx);
        }
        if (cap == ForgeCapabilities.ENERGY && ENERGY_INPUT.equalsOrNullFace(position)) {
            return state.energyHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return CrusherShapes.SHAPE_GETTER;
    }

    private static boolean isInInput(BlockPos posInMultiblock, boolean allowMiddleLayer) {
        if (posInMultiblock.m_123342_() == 2 || allowMiddleLayer && posInMultiblock.m_123342_() == 1) {
            return posInMultiblock.m_123341_() > 0 && posInMultiblock.m_123341_() < 4;
        }
        return false;
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        block11: {
            int consumed;
            IMultiblockLevel level;
            State state;
            block12: {
                block10: {
                    if (collided.f_19853_.f_46443_ || !CrusherLogic.isInInput(posInMultiblock, true)) {
                        return;
                    }
                    state = ctx.getState();
                    if (!collided.m_6084_() || !state.rsState.isEnabled(ctx)) {
                        return;
                    }
                    level = ctx.getLevel();
                    AABB internalBB = new AABB(1.9375, 1.25, 0.9375, 3.0625, 2.5, 2.0625);
                    AABB crusherInternal = level.toAbsolute(internalBB);
                    if (!collided.m_20191_().m_82381_(crusherInternal)) {
                        return;
                    }
                    if (!(collided instanceof ItemEntity)) break block10;
                    ItemEntity itemEntity = (ItemEntity)collided;
                    ItemStack stack = itemEntity.m_32055_();
                    if (stack.m_41619_()) {
                        return;
                    }
                    ItemStack remaining = state.insertionHandler.getValue().insertItem(0, stack, false);
                    if (remaining.m_41619_()) {
                        itemEntity.m_146870_();
                    } else {
                        itemEntity.m_32045_(remaining);
                    }
                    break block11;
                }
                if (!(collided instanceof LivingEntity)) break block11;
                if (!(collided instanceof Player)) break block12;
                Player player = (Player)collided;
                if (player.m_150110_().f_35934_) break block11;
            }
            if ((consumed = state.energy.extractEnergy(80, false)) > 0) {
                EventHandler.crusherMap.put(collided.m_20148_(), s -> state.doProcessOutput((ItemStack)s, level));
                collided.m_6469_(IEDamageSources.crusher(collided.f_19853_), (float)consumed / 20.0f);
            }
        }
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(state -> {
            float fill = (float)state.processor.getQueueSize() / (float)state.processor.getMaxQueueSize();
            return Mth.m_14167_((float)(fill * 14.0f)) + (fill > 0.0f ? 1 : 0);
        }, REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<CrusherRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        private final MultiblockProcessor<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>> processor;
        private boolean renderAsActive;
        private float barrelAngle;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final StoredCapability<IItemHandler> insertionHandler;
        private final StoredCapability<IEnergyStorage> energyHandler = new StoredCapability<AveragingEnergyStorage>(this.energy);
        private BooleanSupplier isPlayingSound = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.processor = new MultiblockProcessor(2048, 0.0f, 1, ctx.getMarkDirtyRunnable(), CrusherRecipe.RECIPES::getById);
            DirectProcessingItemHandler<CrusherRecipe> insertionHandler = new DirectProcessingItemHandler<CrusherRecipe>(ctx.levelSupplier(), this.processor, CrusherRecipe::findRecipe).setProcessStacking(true);
            this.insertionHandler = new StoredCapability<DirectProcessingItemHandler<CrusherRecipe>>(insertionHandler);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInWorld::new);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128379_("renderActive", this.renderAsActive);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.renderAsActive = nbt.m_128471_("renderActive");
        }

        @Override
        public void doProcessOutput(ItemStack output, IMultiblockLevel level) {
            this.output.insertOrDrop(output, level);
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public boolean shouldRenderActive() {
            return this.renderAsActive;
        }

        public float getBarrelAngle() {
            return this.barrelAngle;
        }

        public List<MultiblockProcess<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }
    }
}

