/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingMachineLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BottlingProcess
extends MultiblockProcessInWorld<BottlingMachineRecipe> {
    private static final BottlingMachineRecipe DUMMY_RECIPE = new BottlingMachineRecipe(new ResourceLocation("immersiveengineering", "bottling_dummy_recipe"), List.of(Lazy.of(() -> ItemStack.f_41583_)), IngredientWithSize.of(ItemStack.f_41583_), new FluidTagInput((TagKey<Fluid>)FluidTags.f_13131_, 0));
    private static final float TRANSFORMATION_POINT = 0.45f;
    private final boolean isFilling;
    private ItemStack filledContainer = ItemStack.f_41583_;
    private final FluidTank tank;
    private final BooleanSupplier allowPartialFill;

    public BottlingProcess(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, BottlingMachineRecipe> getRecipe, NonNullList<ItemStack> inputItem, BottlingMachineLogic.State state) {
        super(recipeId, getRecipe, 0.45f, inputItem);
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = false;
    }

    public BottlingProcess(BiFunction<Level, ResourceLocation, BottlingMachineRecipe> getRecipe, CompoundTag nbt, BottlingMachineLogic.State state) {
        super(getRecipe, nbt);
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = nbt.m_128471_("isFilling");
        if (this.isFilling) {
            this.filledContainer = (ItemStack)this.inputItems.get(0);
        }
    }

    public BottlingProcess(BottlingMachineRecipe recipe, NonNullList<ItemStack> inputItem, BottlingMachineLogic.State state) {
        super(recipe, 0.45f, inputItem);
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = false;
    }

    public BottlingProcess(NonNullList<ItemStack> inputItem, BottlingMachineLogic.State state) {
        super(DUMMY_RECIPE, 0.45f, inputItem);
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = true;
        this.filledContainer = (ItemStack)inputItem.get(0);
    }

    public static MultiblockProcessor.InWorldProcessLoader<BottlingMachineRecipe> loader(BottlingMachineLogic.State state) {
        return (getRecipe, tag) -> new BottlingProcess(getRecipe, tag, state);
    }

    @Override
    public void doProcessTick(ProcessContext.ProcessContextInWorld<BottlingMachineRecipe> context, IMultiblockLevel level) {
        FluidStack fs;
        super.doProcessTick(context, level);
        Level rawLevel = level.getRawLevel();
        float transPoint = (float)this.getMaxTicks(rawLevel) * this.transformationPoint;
        if ((float)this.processTick >= transPoint && (float)this.processTick < 1.0f + transPoint && !(fs = this.tank.getFluid()).isEmpty()) {
            if (this.isFilling) {
                ItemStack ret = FluidUtils.fillFluidContainer((IFluidHandler)this.tank, this.filledContainer, ItemStack.f_41583_, null);
                if (!ret.m_41619_()) {
                    this.filledContainer = ret;
                }
                if (!this.allowPartialFill.getAsBoolean() && !FluidUtils.isFluidContainerFull(ret)) {
                    --this.processTick;
                }
            } else {
                this.tank.drain(((BottlingMachineRecipe)this.getRecipe((Level)rawLevel)).fluidInput.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public List<ItemStack> getDisplayItem(Level level) {
        if (this.isFilling) {
            return List.of(this.filledContainer);
        }
        return super.getDisplayItem(level);
    }

    @Override
    protected List<ItemStack> getRecipeItemOutputs(Level level, ProcessContext.ProcessContextInWorld<BottlingMachineRecipe> context) {
        if (this.isFilling) {
            return List.of(this.filledContainer);
        }
        return super.getRecipeItemOutputs(level, context);
    }

    @Override
    public void writeExtraDataToNBT(CompoundTag nbt) {
        super.writeExtraDataToNBT(nbt);
        nbt.m_128379_("isFilling", this.isFilling);
    }
}

