/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SawmillShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.InsertOnlyInventory;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class SawmillLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final int MAX_PROCESSES = 6;
    private static final CapabilityPosition INPUT = new CapabilityPosition(0, 1, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace PRIMARY_OUTPUT = new MultiblockFace(5, 1, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace SIDE_OUTPUT = new MultiblockFace(3, 0, 3, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 2);
    private static final AABB SAWBLADE_AABB = new AABB(2.6875, 1.0, 1.375, 4.3125, 2.0, 1.625);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        boolean rsAllowed = state.rsState.isEnabled(context);
        int i = 0;
        Iterator<SawmillProcess> processIterator = state.sawmillProcessQueue.iterator();
        HashSet<ItemStack> secondaries = new HashSet<ItemStack>();
        while (rsAllowed && processIterator.hasNext() && i++ < 6) {
            SawmillProcess process = processIterator.next();
            if (process.processStep(rawLevel, state.energy, state.sawblade, secondaries)) {
                context.markMasterDirty();
            }
            if (!process.isProcessFinished()) continue;
            state.output.insertOrDrop(process.getCurrentStack(rawLevel, !state.sawblade.m_41619_()).m_41777_(), level);
            processIterator.remove();
            if (state.sawblade.m_220157_(((Integer)IEServerConfig.MACHINES.sawmill_bladeDamage.get()).intValue(), ApiUtils.RANDOM_SOURCE, null)) {
                state.sawblade = ItemStack.f_41583_;
            }
            context.markDirtyAndSync();
        }
        for (ItemStack output : secondaries) {
            state.secondaryOutput.insertOrDrop(output.m_41777_(), level);
        }
        ActiveState renderActive = state.energy.getEnergyStored() <= 0 || !rsAllowed || state.sawblade.m_41619_() ? ActiveState.DISABLED : (state.sawmillProcessQueue.isEmpty() ? ActiveState.IDLE : ActiveState.SAWING);
        if (state.active != renderActive) {
            state.active = renderActive;
            context.markDirtyAndSync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> ctx) {
        boolean shouldPlay;
        IMultiblockLevel level = ctx.getLevel();
        State state = ctx.getState();
        boolean bl = shouldPlay = state.active != ActiveState.DISABLED || state.lastSoundState != ActiveState.DISABLED;
        if (shouldPlay && !state.soundPlaying.get((Object)state.active).getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(2.5, 1.0, 1.5));
            ActiveState active = state.active;
            RegistryObject<SoundEvent> sound = switch (active) {
                default -> throw new IncompatibleClassChangeError();
                case ActiveState.DISABLED -> IESounds.saw_shutdown;
                case ActiveState.IDLE -> IESounds.saw_empty;
                case ActiveState.SAWING -> IESounds.saw_full;
            };
            state.soundPlaying.put(state.active, MultiblockSound.startSound(() -> state.active == active, ctx.isValid(), soundPos, sound, state.active != ActiveState.DISABLED));
        }
        state.lastSoundState = state.active;
        if (state.active == ActiveState.DISABLED) {
            return;
        }
        state.animation_bladeRotation += 36.0f;
        state.animation_bladeRotation %= 360.0f;
        state.sawmillProcessQueue.forEach(SawmillProcess::incrementProcessOnClient);
        Level rawLevel = level.getRawLevel();
        Optional<SawmillProcess> process = state.sawmillProcessQueue.stream().filter(p -> p.isSawing(rawLevel)).findFirst();
        if (process.isPresent()) {
            Direction particleDir = level.toAbsolute(RelativeBlockFace.RIGHT);
            AABB aabb = level.toAbsolute(SAWBLADE_AABB);
            double posX = aabb.f_82288_ + rawLevel.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_);
            double posY = aabb.f_82289_ + rawLevel.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_);
            double posZ = aabb.f_82290_ + rawLevel.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_);
            double vX = rawLevel.f_46441_.m_188500_() * (double)particleDir.m_122429_() * 0.3;
            double vY = rawLevel.f_46441_.m_188500_() * 0.3;
            double vZ = rawLevel.f_46441_.m_188500_() * (double)particleDir.m_122431_() * 0.3;
            rawLevel.m_7107_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, process.get().getCurrentStack(rawLevel, true)), posX, posY, posZ, vX, vY, vZ);
            ++state.count;
            if (state.count % 21 == 0) {
                rawLevel.m_5594_(ImmersiveEngineering.proxy.getClientPlayer(), level.toAbsolute(new BlockPos(2, 1, 1)), (SoundEvent)IESounds.saw_full.get(), SoundSource.BLOCKS, 0.4f, 1.0f);
            }
        } else if (state.count != -1) {
            state.count = -1;
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY && ENERGY_INPUT.equalsOrNullFace(position)) {
            return ctx.getState().energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && INPUT.equals(position)) {
            return ctx.getState().insertionHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        State state = ctx.getState();
        IMultiblockLevel level = ctx.getLevel();
        Level rawLevel = level.getRawLevel();
        if (rawLevel.f_46443_ || collided == null || !collided.m_6084_() || !state.rsState.isEnabled(ctx)) {
            return;
        }
        if (new BlockPos(0, 1, 1).equals((Object)posInMultiblock) && collided instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)collided;
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41619_()) {
                return;
            }
            if (SawmillLogic.insertItemToProcess(stack = stack.m_41777_(), false, state, rawLevel)) {
                ctx.markDirtyAndSync();
            }
            if (stack.m_41613_() <= 0) {
                collided.m_146870_();
            } else {
                itemEntity.m_32045_(stack);
            }
            return;
        }
        AABB absoluteBladeBB = level.toAbsolute(SAWBLADE_AABB);
        if (collided instanceof LivingEntity && !state.sawblade.m_41619_() && absoluteBladeBB.m_82381_(collided.m_20191_())) {
            this.hurtEntity(collided, ctx);
        }
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        State state = ctx.getState();
        ItemStack heldItem = player.m_21120_(hand);
        if (state.rsState.isEnabled(ctx) && !state.sawblade.m_41619_()) {
            if (!isClient && player.m_6144_() && heldItem.m_41619_()) {
                this.hurtEntity((Entity)player, ctx);
            }
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && !state.sawblade.m_41619_() && heldItem.m_41619_()) {
            player.m_21008_(hand, state.sawblade.m_41777_());
            state.sawblade = ItemStack.f_41583_;
            ctx.markDirtyAndSync();
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_204117_(IETags.sawblades)) {
            ItemStack tempBlade = !state.sawblade.m_41619_() ? state.sawblade.m_41777_() : ItemStack.f_41583_;
            state.sawblade = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
            heldItem.m_41774_(1);
            player.m_21008_(hand, heldItem);
            if (!tempBlade.m_41619_()) {
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, tempBlade);
                } else if (!isClient) {
                    player.m_5552_(tempBlade, 0.0f);
                }
            }
            ctx.markDirtyAndSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void hurtEntity(Entity toHurt, IMultiblockContext<State> ctx) {
        if (toHurt instanceof Player) {
            Player player = (Player)toHurt;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        if (!ctx.getState().rsState.isEnabled(ctx)) {
            return;
        }
        int consumed = ctx.getState().energy.extractEnergy(80, false);
        if (consumed > 0) {
            toHurt.m_6469_(IEDamageSources.sawmill(ctx.getLevel().getRawLevel()), 7.0f);
            ctx.markMasterDirty();
        }
    }

    private static boolean insertItemToProcess(ItemStack stack, boolean simulate, State state, Level rawLevel) {
        if (state.sawmillProcessQueue.size() >= 6) {
            return false;
        }
        float dist = 1.0f;
        float minProcessDist = 0.1f;
        SawmillProcess p = null;
        if (state.sawmillProcessQueue.size() > 0) {
            p = state.sawmillProcessQueue.get(state.sawmillProcessQueue.size() - 1);
            if (p != null) {
                dist = p.getRelativeProcessStep(rawLevel);
                if (!stack.m_41656_(p.getInput()) || state.combinedLogs > 2) {
                    if (!simulate) {
                        state.combinedLogs = 0;
                    }
                    minProcessDist = 0.5f;
                }
            }
        } else if (state.combinedLogs > 0) {
            state.combinedLogs = 0;
        }
        if (p != null && dist < minProcessDist) {
            return false;
        }
        if (!simulate) {
            p = new SawmillProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            state.sawmillProcessQueue.add(p);
            ++state.combinedLogs;
        }
        stack.m_41774_(1);
        return true;
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        if (!state.sawblade.m_41619_()) {
            drop.accept(state.sawblade);
        }
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SawmillShapes.SHAPE_GETTER;
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(state -> {
            float damage = 1.0f - (float)state.sawblade.m_41773_() / (float)state.sawblade.m_41776_();
            return Mth.m_14167_((float)(damage * 15.0f));
        }, REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState {
        private final MutableEnergyStorage energy = new MutableEnergyStorage(32000);
        public ItemStack sawblade = ItemStack.f_41583_;
        public final List<SawmillProcess> sawmillProcessQueue = new ArrayList<SawmillProcess>();
        private int combinedLogs = 0;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final DroppingMultiblockOutput secondaryOutput;
        private final StoredCapability<IItemHandler> insertionHandler;
        private final StoredCapability<IEnergyStorage> energyCap;
        public ActiveState active = ActiveState.DISABLED;
        private int count = 0;
        public float animation_bladeRotation = 0.0f;
        private final EnumMap<ActiveState, BooleanSupplier> soundPlaying = new EnumMap(ActiveState.class);
        private ActiveState lastSoundState = ActiveState.DISABLED;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(PRIMARY_OUTPUT, ctx);
            this.secondaryOutput = new DroppingMultiblockOutput(SIDE_OUTPUT, ctx);
            final Supplier<@Nullable Level> levelGetter = ctx.levelSupplier();
            final Runnable markDirty = ctx.getMarkDirtyRunnable();
            final Runnable sync = ctx.getSyncRunnable();
            this.insertionHandler = new StoredCapability<1>(new InsertOnlyInventory(){

                @Override
                protected ItemStack insert(ItemStack toInsert, boolean simulate) {
                    if (SawmillLogic.insertItemToProcess(toInsert = toInsert.m_41777_(), simulate, this, (Level)levelGetter.get())) {
                        markDirty.run();
                        sync.run();
                    }
                    return toInsert;
                }
            });
            this.energyCap = new StoredCapability<MutableEnergyStorage>(this.energy);
            for (ActiveState state : ActiveState.values()) {
                this.soundPlaying.put(state, () -> false);
            }
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128405_("combinedLogs", this.combinedLogs);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.readCommonNBT(nbt);
            this.combinedLogs = nbt.m_128451_("combinedLogs");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.m_128405_("active", this.active.ordinal());
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            this.active = ActiveState.values()[nbt.m_128451_("active")];
        }

        private void writeCommonNBT(CompoundTag nbt) {
            nbt.m_128365_("sawblade", (Tag)this.sawblade.m_41739_(new CompoundTag()));
            ListTag processes = new ListTag();
            for (SawmillProcess process : this.sawmillProcessQueue) {
                processes.add((Object)process.writeToNBT());
            }
            nbt.m_128365_("processes", (Tag)processes);
        }

        private void readCommonNBT(CompoundTag nbt) {
            this.sawblade = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("sawblade"));
            ListTag processes = nbt.m_128437_("processes", 10);
            this.sawmillProcessQueue.clear();
            for (int i = 0; i < processes.size(); ++i) {
                this.sawmillProcessQueue.add(SawmillProcess.readFromNBT(processes.m_128728_(i)));
            }
        }

        public IEnergyStorage getEnergy() {
            return this.energy;
        }
    }

    public static enum ActiveState {
        DISABLED,
        IDLE,
        SAWING;

    }
}

