/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SorterBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IInteractionObjectIE<SorterBlockEntity>,
IEBlockInterfaces.IBlockEntityDrop {
    public static final int FILTER_SLOTS_PER_SIDE = 8;
    public static final int TOTAL_SLOTS = 48;
    public SorterInventory filter;
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    private static Set<BlockPos> routed = null;
    private final Map<Direction, CapabilityReference<IItemHandler>> neighborCaps = CapabilityReference.forAllNeighbors(this, ForgeCapabilities.ITEM_HANDLER);
    private static final CompoundTag EMPTY_NBT = new CompoundTag();
    private final EnumMap<Direction, ResettableCapability<IItemHandler>> insertionHandlers = new EnumMap(Direction.class);

    public SorterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.SORTER.get(), pos, state);
        for (Direction f : DirectionUtils.VALUES) {
            ResettableCapability<SorterInventoryHandler> forSide = this.registerCapability(new SorterInventoryHandler(this, f));
            this.insertionHandlers.put(f, forSide);
        }
        this.filter = new SorterInventory();
    }

    public ItemStack routeItem(Direction inputSide, ItemStack stack, boolean simulate) {
        if (!this.f_58857_.f_46443_ && this.canRoute()) {
            boolean first = this.startRouting();
            Direction[][] validOutputs = this.getValidOutputs(inputSide, stack);
            stack = this.doInsert(stack, validOutputs[0], simulate);
            if (validOutputs[0].length == 0 || !stack.m_41619_()) {
                stack = this.doInsert(stack, validOutputs[1], simulate);
            }
            if (first) {
                routed = null;
            }
        }
        return stack;
    }

    private boolean canRoute() {
        return routed == null || !routed.contains(this.f_58858_);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = routed == null;
        if (first) {
            routed = new HashSet<BlockPos>();
        }
        routed.add(this.f_58858_);
        return first;
    }

    private ItemStack doInsert(ItemStack stack, Direction[] sides, boolean simulate) {
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && !stack.m_41619_(); --lengthFiltered) {
            int rand = ApiUtils.RANDOM.nextInt(lengthFiltered);
            stack = this.outputItemToInv(stack, sides[rand], simulate);
            sides[rand] = sides[lengthFiltered - 1];
        }
        return stack;
    }

    public boolean doOredict(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 1) != 0;
        }
        return false;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 2) != 0;
        }
        return false;
    }

    public boolean doFuzzy(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 4) != 0;
        }
        return false;
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public SorterBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<SorterBlockEntity, ?> getContainerType() {
        return IEMenuTypes.SORTER;
    }

    public Direction[][] getValidOutputs(Direction inputSide, ItemStack stack) {
        if (stack.m_41619_()) {
            return new Direction[][]{new Direction[0], new Direction[0], new Direction[0], new Direction[0]};
        }
        ArrayList<Direction> validFiltered = new ArrayList<Direction>(6);
        ArrayList<Direction> validUnfiltered = new ArrayList<Direction>(6);
        for (Direction side : Direction.values()) {
            if (side == inputSide) continue;
            EnumFilterResult result = this.checkStackAgainstFilter(stack, side);
            if (result == EnumFilterResult.VALID_FILTERED) {
                validFiltered.add(side);
                continue;
            }
            if (result != EnumFilterResult.VALID_UNFILTERED) continue;
            validUnfiltered.add(side);
        }
        return new Direction[][]{validFiltered.toArray(new Direction[0]), validUnfiltered.toArray(new Direction[0])};
    }

    public ItemStack pullItem(Direction outputSide, int amount, boolean simulate) {
        if (!this.f_58857_.f_46443_ && this.canRoute()) {
            boolean first = this.startRouting();
            for (Direction side : Direction.values()) {
                CapabilityReference<IItemHandler> capRef;
                IItemHandler itemHandler;
                if (side == outputSide || (itemHandler = (capRef = this.neighborCaps.get(side)).getNullable()) == null) continue;
                Predicate<ItemStack> concatFilter = null;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractItem = itemHandler.extractItem(i, amount, true);
                    if (extractItem.m_41619_()) continue;
                    if (concatFilter == null) {
                        concatFilter = this.concatFilters(outputSide, side);
                    }
                    if (!concatFilter.test(extractItem)) continue;
                    if (first) {
                        routed = null;
                    }
                    if (!simulate) {
                        itemHandler.extractItem(i, amount, false);
                    }
                    return extractItem;
                }
            }
            if (first) {
                routed = null;
            }
        }
        return ItemStack.f_41583_;
    }

    private boolean compareStackToFilterstack(ItemStack stack, ItemStack filterStack, boolean fuzzy, boolean oredict, boolean nbt) {
        CompoundTag filterTag;
        CompoundTag stackTag;
        int damageFilter;
        int damageStack;
        if (oredict) {
            if (!stack.m_41720_().m_204114_().m_203616_().anyMatch(arg_0 -> ((ItemStack)filterStack).m_204117_(arg_0))) {
                return false;
            }
        } else if (!ItemStack.m_41746_((ItemStack)filterStack, (ItemStack)stack)) {
            return false;
        }
        if (!fuzzy && (stack.m_41763_() || filterStack.m_41763_()) && (damageStack = stack.m_41773_()) != (damageFilter = filterStack.m_41773_())) {
            return false;
        }
        return !nbt || (stackTag = SorterBlockEntity.getTagWithoutDamage(stack)).equals((Object)(filterTag = SorterBlockEntity.getTagWithoutDamage(filterStack)));
    }

    private static CompoundTag getTagWithoutDamage(ItemStack stack) {
        CompoundTag directTag = stack.m_41783_();
        if (directTag == null) {
            return EMPTY_NBT;
        }
        CompoundTag tagCopy = directTag.m_6426_();
        tagCopy.m_128473_("Damage");
        return tagCopy;
    }

    private EnumFilterResult checkStackAgainstFilter(ItemStack stack, Direction side) {
        boolean unmapped = true;
        for (ItemStack filterStack : this.filter.getFilterStacksOnSide(side)) {
            if (filterStack.m_41619_()) continue;
            unmapped = false;
            if (!this.compareStackToFilterstack(stack, filterStack, this.doFuzzy(side.ordinal()), this.doOredict(side.ordinal()), this.doNBT(side.ordinal()))) continue;
            return EnumFilterResult.VALID_FILTERED;
        }
        if (unmapped) {
            return EnumFilterResult.VALID_UNFILTERED;
        }
        return EnumFilterResult.INVALID;
    }

    private Predicate<ItemStack> concatFilters(final Direction side0, Direction side1) {
        final ArrayList<ItemStack> concat = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.filter.getFilterStacksOnSide(side0)) {
            if (itemStack.m_41619_()) continue;
            concat.add(itemStack);
        }
        Predicate<ItemStack> matchFilter = concat.isEmpty() ? stack -> true : new Predicate<ItemStack>(){
            final Set<ItemStack> filter;
            {
                this.filter = new HashSet<ItemStack>(concat);
            }

            @Override
            public boolean test(ItemStack stack) {
                for (ItemStack filterStack : this.filter) {
                    if (!SorterBlockEntity.this.compareStackToFilterstack(stack, filterStack, SorterBlockEntity.this.doFuzzy(side0.ordinal()), SorterBlockEntity.this.doOredict(side0.ordinal()), SorterBlockEntity.this.doNBT(side0.ordinal()))) continue;
                    return true;
                }
                return false;
            }
        };
        for (ItemStack filterStack : this.filter.getFilterStacksOnSide(side1)) {
            if (filterStack.m_41619_() || !matchFilter.test(filterStack)) continue;
            concat.add(filterStack);
        }
        boolean bl = this.doFuzzy(side0.ordinal()) | this.doFuzzy(side1.ordinal());
        boolean concatOredict = this.doOredict(side0.ordinal()) | this.doOredict(side1.ordinal());
        boolean concatNBT = this.doNBT(side0.ordinal()) | this.doNBT(side1.ordinal());
        return concat.isEmpty() ? stack -> true : stack -> {
            for (ItemStack filterStack : concat) {
                if (!this.compareStackToFilterstack((ItemStack)stack, filterStack, concatFuzzy, concatOredict, concatNBT)) continue;
                return true;
            }
            return false;
        };
    }

    public ItemStack outputItemToInv(ItemStack stack, Direction side, boolean simulate) {
        return Utils.insertStackIntoInventory(this.neighborCaps.get(side), stack, simulate);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.sideFilter = nbt.m_128465_("sideFilter");
        if (!descPacket) {
            ListTag filterList = nbt.m_128437_("filter", 10);
            this.filter = new SorterInventory();
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128385_("sideFilter", this.sideFilter);
        if (!descPacket) {
            ListTag filterList = new ListTag();
            this.filter.writeToNBT(filterList);
            nbt.m_128365_("filter", (Tag)filterList);
        }
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        this.writeCustomNBT(stack.m_41784_(), false);
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (stack.m_41782_()) {
            this.readCustomNBT(stack.m_41784_(), false);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null) {
            return this.insertionHandlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        return id == 0;
    }

    public static class SorterInventoryHandler
    implements IItemHandlerModifiable {
        SorterBlockEntity sorter;
        Direction side;

        public SorterInventoryHandler(SorterBlockEntity sorter, Direction side) {
            this.sorter = sorter;
            this.side = side;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.sorter.routeItem(this.side, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.sorter.pullItem(this.side, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class SorterInventory
    extends ItemStackHandler {
        public SorterInventory() {
            super(NonNullList.m_122780_((int)48, (Object)ItemStack.f_41583_));
        }

        public ItemStack getStackBySideAndSlot(Direction side, int slotOnSide) {
            return this.getStackInSlot(this.getSlotId(side, slotOnSide));
        }

        public int getSlotId(Direction side, int slotOnSide) {
            return side.ordinal() * 8 + slotOnSide;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public Iterable<ItemStack> getFilterStacksOnSide(Direction side) {
            return () -> Iterators.transform((Iterator)IntIterators.fromTo((int)0, (int)8), i -> this.getStackBySideAndSlot(side, (int)i));
        }

        public void writeToNBT(ListTag list) {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack slot = this.getStackInSlot(i);
                if (slot.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128344_("Slot", (byte)i);
                slot.m_41739_(itemTag);
                list.add((Object)itemTag);
            }
        }

        public void readFromNBT(ListTag list) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.m_128728_(i);
                int slot = itemTag.m_128445_("Slot") & 0xFF;
                if (slot >= this.getSlots()) continue;
                this.setStackInSlot(slot, ItemStack.m_41712_((CompoundTag)itemTag));
            }
        }
    }

    private static enum EnumFilterResult {
        INVALID,
        VALID_FILTERED,
        VALID_UNFILTERED;

    }
}

