/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.datafix;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class RenameMultiblockBEsFix {
    private static final Map<String, String> MULTIBLOCK_BE_RENAMES = new HashMap<String, String>();

    private static void registerFix(String oldName, MultiblockRegistration<?> newVersion) {
        MULTIBLOCK_BE_RENAMES.put(oldName, newVersion.id().m_135815_());
    }

    public static Optional<BlockEntityType<?>> replaceIfMissing(Optional<BlockEntityType<?>> baseType, CompoundTag tag) {
        String suffix;
        if (baseType.isPresent()) {
            return baseType;
        }
        ResourceLocation nbtName = new ResourceLocation(tag.m_128461_("id"));
        if (!nbtName.m_135827_().equals("immersiveengineering")) {
            return baseType;
        }
        if (nbtName.m_135815_().endsWith("_master")) {
            suffix = "_master";
        } else if (nbtName.m_135815_().endsWith("_dummy")) {
            suffix = "_dummy";
        } else {
            return baseType;
        }
        String baseName = nbtName.m_135815_().substring(0, nbtName.m_135815_().length() - suffix.length());
        String remapped = MULTIBLOCK_BE_RENAMES.get(baseName);
        if (remapped == null) {
            return baseType;
        }
        ResourceLocation newName = nbtName.m_247449_(remapped + suffix);
        return BuiltInRegistries.f_257049_.m_6612_(newName);
    }

    static {
        RenameMultiblockBEsFix.registerFix("cokeoven", IEMultiblockLogic.COKE_OVEN);
        RenameMultiblockBEsFix.registerFix("blastfurnace", IEMultiblockLogic.BLAST_FURNACE);
        RenameMultiblockBEsFix.registerFix("blastfurnaceadvanced", IEMultiblockLogic.ADV_BLAST_FURNACE);
        RenameMultiblockBEsFix.registerFix("alloysmelter", IEMultiblockLogic.ALLOY_SMELTER);
        RenameMultiblockBEsFix.registerFix("lightningrod", IEMultiblockLogic.LIGHTNING_ROD);
        RenameMultiblockBEsFix.registerFix("dieselgenerator", IEMultiblockLogic.DIESEL_GENERATOR);
        RenameMultiblockBEsFix.registerFix("metalpress", IEMultiblockLogic.METAL_PRESS);
        RenameMultiblockBEsFix.registerFix("autoworkbench", IEMultiblockLogic.AUTO_WORKBENCH);
        RenameMultiblockBEsFix.registerFix("bottlingmachine", IEMultiblockLogic.BOTTLING_MACHINE);
        RenameMultiblockBEsFix.registerFix("sheetmetaltank", IEMultiblockLogic.TANK);
        RenameMultiblockBEsFix.registerFix("bucketwheel", IEMultiblockLogic.BUCKET_WHEEL);
        RenameMultiblockBEsFix.registerFix("arcfurnace", IEMultiblockLogic.ARC_FURNACE);
    }
}

