/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.datafix;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.util.datafix.fixes.References;

public class RotateMultiblocksFix
extends DataFix {
    private static final String PROPERTIES_KEY = "Properties";
    private static final String FACING_KEY = IEProperties.FACING_HORIZONTAL.m_61708_();
    private static final Supplier<Set<String>> STONE_MULTIBLOCKS = Suppliers.memoize(() -> Set.of(IEMultiblockLogic.ALLOY_SMELTER.id().toString(), IEMultiblockLogic.ADV_BLAST_FURNACE.id().toString(), IEMultiblockLogic.BLAST_FURNACE.id().toString(), IEMultiblockLogic.COKE_OVEN.id().toString()));
    private static final Supplier<String> METAL_PRESS = Suppliers.memoize(() -> IEMultiblockLogic.METAL_PRESS.id().toString());

    public static void registerFix(Schema newSchema, DataFixerBuilder builder) {
        Preconditions.checkState((newSchema.getVersionKey() == DataFixUtils.makeKey((int)3214, (int)0) ? 1 : 0) != 0);
        builder.addFixer((DataFix)new RotateMultiblocksFix(newSchema));
    }

    public RotateMultiblocksFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type inputBlockStateType = this.getInputSchema().getType(References.f_16783_);
        return this.fixTypeEverywhereTyped("Rotate IE multiblocks", inputBlockStateType, this::fixBlockstate);
    }

    private Typed<?> fixBlockstate(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), blockstateDynamic -> {
            Optional maybeName = blockstateDynamic.get("Name").asString().result();
            if (maybeName.isEmpty()) {
                return blockstateDynamic;
            }
            if (STONE_MULTIBLOCKS.get().contains(maybeName.get())) {
                return this.fixDirection((Dynamic<?>)blockstateDynamic, Direction::m_122424_);
            }
            if (METAL_PRESS.get().equals(maybeName.get())) {
                return this.fixDirection((Dynamic<?>)blockstateDynamic, Direction::m_122428_);
            }
            return blockstateDynamic;
        });
    }

    private Dynamic<?> fixDirection(Dynamic<?> blockState, UnaryOperator<Direction> directionFix) {
        Optional maybeProperties = blockState.get(PROPERTIES_KEY).get().result();
        if (maybeProperties.isEmpty()) {
            return blockState;
        }
        Dynamic properties = (Dynamic)maybeProperties.get();
        Optional maybeFacing = properties.get(FACING_KEY).asString().result();
        if (maybeFacing.isEmpty()) {
            return blockState;
        }
        Direction facing = Direction.m_122402_((String)((String)maybeFacing.get()));
        if (facing == null) {
            return blockState;
        }
        String newFacingName = ((Direction)directionFix.apply(facing)).m_7912_();
        Dynamic newProperties = properties.set(FACING_KEY, properties.createString(newFacingName));
        return blockState.set(PROPERTIES_KEY, newProperties);
    }
}

