/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilBlockEntity;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FluorescentTubeEntity
extends Entity
implements ITeslaEntity {
    public static final float TUBE_LENGTH = 1.5f;
    private static final EntityDataAccessor<Boolean> dataMarker_active = SynchedEntityData.m_135353_(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> dataMarker_r = SynchedEntityData.m_135353_(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> dataMarker_g = SynchedEntityData.m_135353_(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> dataMarker_b = SynchedEntityData.m_135353_(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> dataMarker_angleHorizontal = SynchedEntityData.m_135353_(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int timer = 0;
    public boolean active = false;
    public float[] rgb = new float[4];
    boolean f_19803_ = true;
    public float angleHorizontal = 0.0f;

    public FluorescentTubeEntity(Level world, ItemStack tube, float angleVert) {
        this((EntityType<FluorescentTubeEntity>)((EntityType)IEEntityTypes.FLUORESCENT_TUBE.get()), world);
        this.m_146922_(angleVert);
        this.rgb = FluorescentTubeItem.getRGB(tube);
    }

    public FluorescentTubeEntity(EntityType<FluorescentTubeEntity> type, Level world) {
        super(type, world);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 motion = this.m_20184_();
        motion = motion.m_82520_(0.0, -0.4, 0.0);
        this.m_6478_(MoverType.SELF, motion);
        motion = motion.m_82490_(0.98);
        if (this.f_19861_) {
            motion = new Vec3(motion.f_82479_ * 0.7, motion.f_82480_ * -0.5, motion.f_82481_ * 0.7);
        }
        if (this.f_19803_ && !this.f_19853_.f_46443_ && this.rgb != null) {
            this.f_19804_.m_135381_(dataMarker_r, (Object)Float.valueOf(this.rgb[0]));
            this.f_19804_.m_135381_(dataMarker_g, (Object)Float.valueOf(this.rgb[1]));
            this.f_19804_.m_135381_(dataMarker_b, (Object)Float.valueOf(this.rgb[2]));
            this.f_19804_.m_135381_(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            this.f_19803_ = false;
        }
        if (this.timer > 0 && !this.f_19853_.f_46443_) {
            --this.timer;
            if (this.timer <= 0) {
                this.f_19804_.m_135381_(dataMarker_active, (Object)false);
            }
        }
        if (this.f_19853_.f_46443_) {
            this.active = (Boolean)this.f_19804_.m_135370_(dataMarker_active);
            this.rgb = new float[]{((Float)this.f_19804_.m_135370_(dataMarker_r)).floatValue(), ((Float)this.f_19804_.m_135370_(dataMarker_g)).floatValue(), ((Float)this.f_19804_.m_135370_(dataMarker_b)).floatValue()};
            this.angleHorizontal = ((Float)this.f_19804_.m_135370_(dataMarker_angleHorizontal)).floatValue();
        }
        this.m_20256_(motion);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(dataMarker_r, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(dataMarker_g, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(dataMarker_b, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(dataMarker_active, (Object)false);
        this.f_19804_.m_135372_(dataMarker_angleHorizontal, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag nbt) {
        CompoundTag comp = nbt.m_128469_("nbt");
        this.rgb = new float[]{comp.m_128457_("r"), comp.m_128457_("g"), comp.m_128457_("b")};
        this.angleHorizontal = nbt.m_128457_("angleHor");
    }

    protected void m_7380_(CompoundTag nbt) {
        CompoundTag comp = new CompoundTag();
        comp.m_128350_("r", this.rgb[0]);
        comp.m_128350_("g", this.rgb[1]);
        comp.m_128350_("b", this.rgb[2]);
        nbt.m_128365_("nbt", (Tag)comp);
        nbt.m_128350_("angleHor", this.angleHorizontal);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            ItemStack tube = new ItemStack(IEItems.Misc.FLUORESCENT_TUBE);
            FluorescentTubeItem.setRGB(tube, this.rgb);
            ItemEntity ent = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), tube);
            this.f_19853_.m_7967_((Entity)ent);
            this.m_146870_();
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    @Override
    public void onHit(BlockEntity te, boolean lowPower) {
        if (te instanceof TeslaCoilBlockEntity && ((TeslaCoilBlockEntity)te).energyStorage.extractEnergy(1, false) > 0) {
            this.timer = 35;
            this.f_19804_.m_135381_(dataMarker_active, (Object)true);
        }
    }

    @Nonnull
    public InteractionResult m_7111_(Player player, Vec3 targetVec3, InteractionHand hand) {
        if (Utils.isHammer(player.m_21120_(hand))) {
            this.angleHorizontal += (float)(player.m_6144_() ? 10 : 1);
            this.angleHorizontal %= 360.0f;
            this.f_19804_.m_135381_(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, targetVec3, hand);
    }
}

