/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkylineHelper {
    private static final double LN_0_98 = Math.log(0.98);

    public static void spawnHook(LivingEntity player, Connection connection, InteractionHand hand, boolean limitSpeed) {
        if (!player.f_19853_.f_46443_) {
            GlobalWireNetwork global = GlobalWireNetwork.getNetwork(player.f_19853_);
            ConnectionPoint cpA = connection.getEndA();
            ConnectionPoint cpB = connection.getEndB();
            IImmersiveConnectable iicB = global.getExistingConnector(cpB);
            IImmersiveConnectable iicA = global.getExistingConnector(cpA);
            Vec3 vStart = Vec3.m_82528_((Vec3i)cpA.position());
            Vec3 vEnd = Vec3.m_82528_((Vec3i)cpB.position());
            if (iicB != null) {
                vStart = vStart.m_82549_(iicB.getConnectionOffset(cpB, cpA, connection.type));
            }
            if (iicA != null) {
                vEnd = vEnd.m_82549_(iicA.getConnectionOffset(cpA, cpB, connection.type));
            }
            Vec3 pos = player.m_20299_(0.0f);
            Vec3 across = new Vec3(vEnd.f_82479_ - vStart.f_82479_, vEnd.f_82480_ - vStart.f_82480_, vEnd.f_82481_ - vStart.f_82481_);
            double linePos = WireUtils.getCoeffForMinDistance(pos, vStart, across);
            Connection.CatenaryData catData = connection.getCatenaryData();
            Vec3 playerMovement = new Vec3(player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_);
            double slopeAtPos = connection.getSlope(linePos, cpA);
            Vec3 extendedWire = catData.isVertical() ? new Vec3(0.0, catData.horLength(), 0.0) : new Vec3(catData.getDeltaX(), slopeAtPos * catData.horLength(), catData.getDeltaZ());
            extendedWire = extendedWire.m_82541_();
            double totalSpeed = playerMovement.m_82526_(extendedWire);
            double horSpeed = totalSpeed / Math.sqrt(1.0 + slopeAtPos * slopeAtPos);
            SkylineHookEntity hook = new SkylineHookEntity(player.f_19853_, connection, cpA, linePos, hand, horSpeed, limitSpeed);
            IELogger.logger.info("Speed keeping: Player {}, wire {}, Pos: {}", (Object)playerMovement, (Object)extendedWire, (Object)hook.m_20182_());
            if (hook.isValidPosition(hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), player)) {
                double vertSpeed = Math.sqrt(totalSpeed * totalSpeed - horSpeed * horSpeed);
                double speedDiff = player.m_20184_().f_82480_ - vertSpeed;
                if (speedDiff < 0.0) {
                    player.m_142535_(SkylineHelper.fallDistanceFromSpeed(speedDiff), 1.2f, player.m_269291_().m_268989_());
                    player.f_19789_ = 0.0f;
                }
                player.f_19853_.m_7967_((Entity)hook);
                player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).ifPresent(data -> {
                    data.startRiding();
                    data.hook = hook;
                });
                player.m_20329_((Entity)hook);
                IELogger.logger.debug("Started riding");
            } else {
                IELogger.logger.debug("Invalid pos");
            }
        }
    }

    public static float fallDistanceFromSpeed(double v) {
        double fallTime = Math.log(v / 3.92 + 1.0) / LN_0_98;
        return -((float)(196.0 - 3.92 * fallTime - 194.04 * Math.pow(0.98, fallTime - 0.5)));
    }

    public static List<VoxelShape> getCollisionBoxes(@Nullable Entity entityIn, AABB aabb, Level w, Collection<BlockPos> ignored) {
        ArrayList list = Lists.newArrayList();
        SkylineHelper.getBlockCollisionBoxes(entityIn, aabb, list, w, ignored);
        w.m_186434_(entityIn, aabb).forEach(list::add);
        return list;
    }

    public static void getBlockCollisionBoxes(final @Nullable Entity entityIn, AABB aabb, @Nonnull List<VoxelShape> outList, final Level w, final Collection<BlockPos> ignored) {
        int minX = Mth.m_14107_((double)(aabb.f_82288_ - 1.0E-7)) - 1;
        int maxX = Mth.m_14107_((double)(aabb.f_82291_ + 1.0E-7)) + 1;
        int minY = Mth.m_14107_((double)(aabb.f_82289_ - 1.0E-7)) - 1;
        int maxY = Mth.m_14107_((double)(aabb.f_82292_ + 1.0E-7)) + 1;
        int minZ = Mth.m_14107_((double)(aabb.f_82290_ - 1.0E-7)) - 1;
        int maxZ = Mth.m_14107_((double)(aabb.f_82293_ + 1.0E-7)) + 1;
        final CollisionContext selectionCtx = entityIn == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)entityIn);
        final Cursor3D it = new Cursor3D(minX, minY, minZ, maxX, maxY, maxZ);
        final BlockPos.MutableBlockPos currPos = new BlockPos.MutableBlockPos();
        final VoxelShape searchShape = Shapes.m_83064_((AABB)aabb);
        StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean isEntityNull;
            {
                super(est, additionalCharacteristics);
                this.isEntityNull = entityIn == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> add) {
                VoxelShape blockShapeWithOffset;
                if (!this.isEntityNull) {
                    assert (entityIn != null);
                    this.isEntityNull = true;
                    VoxelShape worldBorder = w.m_6857_().m_61946_();
                    boolean veryOutside = Shapes.m_83157_((VoxelShape)worldBorder, (VoxelShape)Shapes.m_83064_((AABB)entityIn.m_20191_().m_82406_(1.0E-7)), (BooleanOp)BooleanOp.f_82689_);
                    boolean nearlyOutside = Shapes.m_83157_((VoxelShape)worldBorder, (VoxelShape)Shapes.m_83064_((AABB)entityIn.m_20191_().m_82400_(1.0E-7)), (BooleanOp)BooleanOp.f_82689_);
                    if (!veryOutside && nearlyOutside) {
                        add.accept((VoxelShape)worldBorder);
                        return true;
                    }
                }
                while (true) {
                    VoxelShape blockShape;
                    int chunkZ;
                    int chunkX;
                    BlockGetter iblockreader;
                    if (!it.m_122304_()) {
                        return false;
                    }
                    int currX = it.m_122305_();
                    int currY = it.m_122306_();
                    int currZ = it.m_122307_();
                    int numBounderies = it.m_122308_();
                    if (numBounderies == 3 || (iblockreader = w.m_7925_(chunkX = currX >> 4, chunkZ = currZ >> 4)) == null) continue;
                    currPos.m_122178_(currX, currY, currZ);
                    BlockState blockstate = iblockreader.m_8055_((BlockPos)currPos);
                    if (!(numBounderies == 1 && !blockstate.m_60779_() || numBounderies == 2 && blockstate.m_60734_() != Blocks.f_50110_ || ignored.contains(currPos) || !Shapes.m_83157_((VoxelShape)searchShape, (VoxelShape)(blockShapeWithOffset = (blockShape = blockstate.m_60742_((BlockGetter)w, (BlockPos)currPos, selectionCtx)).m_83216_((double)currX, (double)currY, (double)currZ)), (BooleanOp)BooleanOp.f_82689_))) break;
                }
                add.accept((VoxelShape)blockShapeWithOffset);
                return true;
            }
        }, false).forEach(outList::add);
    }
}

