/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BlastFurnaceRecipeCategory
extends IERecipeCategory<BlastFurnaceRecipe> {
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;

    public BlastFurnaceRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.BLAST_FURNACE, "gui.immersiveengineering.blastFurnace");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/blast_furnace.png");
        this.setBackground(helper.createDrawable(background, 42, 9, 100, 64));
        this.setIcon(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)IEMultiblockLogic.BLAST_FURNACE.iconStack()));
        this.flame = helper.drawableBuilder(background, 177, 0, 14, 14).buildAnimated(300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.drawableBuilder(background, 176, 14, 24, 17).buildAnimated(300, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlastFurnaceRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 8).addItemStacks(Arrays.asList(recipe.input.getMatchingStacks()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 8).addItemStack((ItemStack)recipe.output.get());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 44).addItemStack((ItemStack)recipe.slag.get());
    }

    public void draw(BlastFurnaceRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.flame.draw(stack, 12, 27);
        this.arrow.draw(stack, 33, 26);
        String burnTime = I18n.m_118938_((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.formatDouble((float)recipe.time / 20.0f, "#.##")});
        ClientUtils.font().m_92883_(stack, burnTime, (float)(68 - ClientUtils.font().m_92895_(burnTime)), 48.0f, 0x777777);
    }
}

