/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class IEBlockEntitySound
implements TickableSoundInstance {
    protected Sound sound;
    private final ResourceLocation resource;
    private final float volume;
    private final float pitch;
    private final BlockPos tilePos;
    private float volumeAjustment = 1.0f;
    public boolean donePlaying = false;

    public IEBlockEntitySound(SoundEvent event, float volume, float pitch, BlockPos pos) {
        this.resource = event.m_11660_();
        this.volume = volume;
        this.pitch = pitch;
        this.tilePos = pos;
    }

    public SoundInstance.Attenuation m_7438_() {
        return SoundInstance.Attenuation.LINEAR;
    }

    public ResourceLocation m_7904_() {
        return this.resource;
    }

    @Nullable
    public WeighedSoundEvents m_6775_(SoundManager handler) {
        WeighedSoundEvents soundEvent = handler.m_120384_(this.resource);
        this.sound = soundEvent == null ? SoundManager.f_120344_ : soundEvent.m_213718_(ApiUtils.RANDOM_SOURCE);
        return soundEvent;
    }

    public Sound m_5891_() {
        return this.sound;
    }

    public SoundSource m_8070_() {
        return SoundSource.BLOCKS;
    }

    public float m_7769_() {
        return this.volume * this.volumeAjustment;
    }

    public float m_7783_() {
        return this.pitch;
    }

    public double m_7772_() {
        return this.tilePos.m_123341_();
    }

    public double m_7780_() {
        return this.tilePos.m_123342_();
    }

    public double m_7778_() {
        return this.tilePos.m_123343_();
    }

    public boolean m_7775_() {
        return true;
    }

    public boolean m_7796_() {
        return false;
    }

    public int m_7766_() {
        return 0;
    }

    public void evaluateVolume() {
        BlockEntity tile;
        ItemStack earmuffs;
        this.volumeAjustment = 1.0f;
        if (ClientUtils.mc().f_91074_ != null && !(earmuffs = EarmuffsItem.EARMUFF_GETTERS.getFrom((LivingEntity)ClientUtils.mc().f_91074_)).m_41619_()) {
            this.volumeAjustment = EarmuffsItem.getVolumeMod(earmuffs);
        }
        if (!((tile = ClientUtils.mc().f_91074_.f_19853_.m_7702_(this.tilePos)) instanceof IEBlockInterfaces.ISoundBE)) {
            this.donePlaying = true;
        } else {
            IEBlockInterfaces.ISoundBE soundBE = (IEBlockInterfaces.ISoundBE)tile;
            boolean bl = this.donePlaying = !soundBE.shouldPlaySound(this.resource.toString());
            if (!this.donePlaying) {
                float radiusSq = soundBE.getSoundRadiusSq();
                if (ClientUtils.mc().f_91074_ != null) {
                    double distSq = ClientUtils.mc().f_91074_.m_20238_(Vec3.m_82512_((Vec3i)this.tilePos));
                    if (distSq > (double)radiusSq) {
                        this.donePlaying = true;
                    } else {
                        this.volumeAjustment = (float)((double)this.volumeAjustment * (((double)radiusSq - distSq) / (double)radiusSq));
                    }
                }
            }
        }
    }

    public void m_7788_() {
        if (ClientUtils.mc().f_91074_ != null && ClientUtils.mc().f_91074_.f_19853_.m_46467_() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean m_7801_() {
        return this.donePlaying;
    }
}

