/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.localhandlers.ICollisionHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WireCollisions {
    public static void handleEntityCollision(BlockPos p, Entity e) {
        block4: {
            LivingEntity living;
            block5: {
                if (e.f_19853_.f_46443_ || !((Boolean)IEServerConfig.WIRES.enableWireDamage.get()).booleanValue() || !(e instanceof LivingEntity)) break block4;
                living = (LivingEntity)e;
                if (!(e instanceof Player)) break block5;
                Player player = (Player)e;
                if (player.m_150110_().f_35934_) break block4;
            }
            GlobalWireNetwork global = GlobalWireNetwork.getNetwork(e.f_19853_);
            WireCollisionData wireData = global.getCollisionData();
            Collection<WireCollisionData.CollisionInfo> atBlock = wireData.getCollisionInfo(p);
            for (WireCollisionData.CollisionInfo info : atBlock) {
                LocalWireNetwork local = info.getLocalNet(global);
                for (LocalNetworkHandler h : local.getAllHandlers()) {
                    if (!(h instanceof ICollisionHandler)) continue;
                    ICollisionHandler collisionHandler = (ICollisionHandler)((Object)h);
                    collisionHandler.onCollided(living, p, info);
                }
            }
        }
    }

    public static void notifyBlockUpdate(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, int flags) {
        GlobalWireNetwork globalNet;
        Collection<WireCollisionData.CollisionInfo> data;
        if (((Boolean)IEServerConfig.WIRES.blocksBreakWires.get()).booleanValue() && !worldIn.f_46443_ && (flags & 1) != 0 && !newState.m_60812_((BlockGetter)worldIn, pos).m_83281_() && !(data = (globalNet = GlobalWireNetwork.getNetwork(worldIn)).getCollisionData().getCollisionInfo(pos)).isEmpty()) {
            HashMap<Connection, BlockPos> toBreak = new HashMap<Connection, BlockPos>();
            for (WireCollisionData.CollisionInfo collisionInfo : data) {
                Vec3 vecB;
                Vec3 vecA;
                if (!collisionInfo.isInBlock() || Utils.isVecInBlock(vecA = collisionInfo.connection().getPoint(0.0, collisionInfo.connection().getEndA()), pos, collisionInfo.connection().getEndA().position(), 0.001) || Utils.isVecInBlock(vecB = collisionInfo.connection().getPoint(0.0, collisionInfo.connection().getEndB()), pos, collisionInfo.connection().getEndB().position(), 0.001)) continue;
                BlockPos dropPos = pos;
                if (!WireUtils.preventsConnection(worldIn, pos, newState, collisionInfo.intersectA(), collisionInfo.intersectB())) continue;
                for (Direction f : DirectionUtils.VALUES) {
                    if (!worldIn.m_46859_(pos.m_121945_(f))) continue;
                    dropPos = dropPos.m_121945_(f);
                    break;
                }
                toBreak.put(collisionInfo.connection(), dropPos);
            }
            for (Map.Entry entry : toBreak.entrySet()) {
                globalNet.removeAndDropConnection((Connection)entry.getKey(), (BlockPos)entry.getValue(), worldIn);
            }
        }
    }
}

