/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.capability;

import com.elenai.feathers.config.FeathersCommonConfig;
import net.minecraft.nbt.CompoundTag;

public class PlayerFeathers {
    private int feathers = 20;
    private final int MAX_FEATHERS = 20;
    private final int MIN_FEATHERS = 0;
    private int enduranceFeathers = 0;
    private int cooldown = 0;
    private int maxCooldown = (Integer)FeathersCommonConfig.REGEN_SPEED.get();
    private final int MIN_COOLDOWN = 0;
    private boolean cold = false;

    public int getFeathers() {
        return this.feathers;
    }

    public void setFeathers(int feathers) {
        this.feathers = feathers;
    }

    public void addFeathers(int feathers) {
        this.feathers = Math.min(this.feathers + feathers, 20);
    }

    public void subFeathers(int feathers) {
        this.feathers = Math.max(this.feathers - feathers, 0);
    }

    public void copyFrom(PlayerFeathers source) {
        this.feathers = source.feathers;
        this.cooldown = source.cooldown;
        this.enduranceFeathers = source.enduranceFeathers;
        this.cold = source.cold;
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128405_("feathers", this.feathers);
        nbt.m_128405_("cooldown", this.cooldown);
        nbt.m_128405_("endurance_feathers", this.enduranceFeathers);
        nbt.m_128379_("cold", this.cold);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.feathers = nbt.m_128451_("feathers");
        this.cooldown = nbt.m_128451_("cooldown");
        this.enduranceFeathers = nbt.m_128451_("endurance_feathers");
        this.cold = nbt.m_128471_("cold");
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void addCooldown(int ticks) {
        this.cooldown = Math.min(this.cooldown + ticks, this.maxCooldown);
    }

    public void subCooldown(int ticks) {
        this.cooldown = Math.max(this.cooldown - ticks, 0);
    }

    public boolean isCold() {
        return this.cold;
    }

    public void setCold(boolean cold) {
        this.cold = cold;
    }

    public int getEnduranceFeathers() {
        return this.enduranceFeathers;
    }

    public void setEnduranceFeathers(int enduranceFeathers) {
        this.enduranceFeathers = enduranceFeathers;
    }

    public void addEndurance(int feathers) {
        this.enduranceFeathers += feathers;
    }

    public void subEndurance(int feathers) {
        this.enduranceFeathers = Math.max(this.enduranceFeathers - feathers, 0);
    }
}

