/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class FeathersCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> REGEN_SPEED;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMOR_WEIGHTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ARMOR_WEIGHTS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_FROST_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_LIGHTWEIGHT_ENCHANTMENT;
    public static List<String> armorWeightBuilder;

    static {
        armorWeightBuilder = new ArrayList<String>();
        BUILDER.push("Feathers' Config");
        REGEN_SPEED = BUILDER.comment("How many ticks it takes to regenerate half a feather.").define("Regeneration Speed", (Object)40);
        ForgeRegistries.ITEMS.forEach(i -> {
            Item patt1253$temp = i.m_5456_();
            if (patt1253$temp instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)patt1253$temp;
                int def = armor.m_40404_();
                armorWeightBuilder.add(i.m_5524_() + ":" + def);
            }
        });
        ARMOR_WEIGHTS = BUILDER.comment("How many half feathers each item weighs.").defineList("Armor Weights Override", (List)Lists.newArrayList(armorWeightBuilder), o -> o instanceof String);
        ENABLE_ARMOR_WEIGHTS = BUILDER.comment("If enabled, armor types have weight, this reduces the amount of feathers you can use based on how heavy your armor is").define("Enable Armor Weights", true);
        ENABLE_FROST_EFFECTS = BUILDER.comment("Whether feathers freeze in cold biomes. If they do, they don't regenerate until in a different biome").define("Enable Frost In Cold Biomes", false);
        ENABLE_LIGHTWEIGHT_ENCHANTMENT = BUILDER.comment("Whether the Lightweight enchantment can be enhanted in an enchantment table, or if it is treasure only.").define("Enable Lightweight Enchantment in Table", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

