/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.util;

import com.elenai.feathers.Feathers;
import com.elenai.feathers.config.FeathersCommonConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class ArmorHandler {
    private static HashMap<String, Integer> map = new HashMap();

    public static HashMap<String, Integer> getWeights() {
        if (map.isEmpty()) {
            ArmorHandler.populateWeights();
        }
        return map;
    }

    public static void populateWeights() {
        map.clear();
        ((List)FeathersCommonConfig.ARMOR_WEIGHTS.get()).forEach(value -> {
            String[] split = value.split(":");
            try {
                map.putIfAbsent(split[0], Integer.parseInt(split[1]));
            }
            catch (Exception e) {
                Feathers.logger.warn(e + " error! Armor value not set as an integer.");
            }
        });
    }

    public static int getArmorWeight(ArmorItem armor) {
        return ArmorHandler.getWeights().getOrDefault(armor.m_5524_(), armor.m_40404_());
    }

    public static int getTotalEnchantmentLevel(Enchantment enchantment, LivingEntity entity) {
        Collection iterable = enchantment.m_44684_(entity).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = itemstack.getEnchantmentLevel(enchantment);
            i += j;
        }
        return i;
    }

    public static int getItemEnchantmentLevel(Enchantment enchantment, ItemStack itemstack) {
        return itemstack.getEnchantmentLevel(enchantment);
    }
}

