/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret;

import com.jtorleonstudios.libraryferret.LibraryFerretClient;
import com.jtorleonstudios.libraryferret.blocks.Blocks;
import com.jtorleonstudios.libraryferret.conf.Configuration;
import com.jtorleonstudios.libraryferret.conf.Props;
import com.jtorleonstudios.libraryferret.effect.StatusEffects;
import com.jtorleonstudios.libraryferret.items.Items;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="libraryferret")
public class LibraryFerret {
    public static boolean isLOADED = false;
    public static final String MOD_ID = "libraryferret";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Optional<CreativeModeTab> FERRET_ITEM_GROUP = Optional.empty();
    public static final Props ENABLED_FERRET_ITEM_GROUP = Props.create("creative", "enable_item_group_ferret", false);
    public static final Configuration CONF = new Configuration("libraryferret", ENABLED_FERRET_ITEM_GROUP);

    public LibraryFerret() {
        isLOADED = false;
        LOGGER.info("Initialize mod Library Ferret");
        IEventBus e = FMLJavaModLoadingContext.get().getModEventBus();
        StatusEffects.registerEffect(e);
        Items.registerItems(e);
        Blocks.registerBlocks(e);
        e.addListener(this::doCommonStuff);
        e.addListener(this::doClientStuff);
        if (CONF.getBoolOrDefault(ENABLED_FERRET_ITEM_GROUP)) {
            e.addListener(this::registerCreativeTab);
        }
        isLOADED = true;
        LOGGER.info("Initialized mod Library Ferret");
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> LibraryFerretClient::register);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_IRON_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_GOLD_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_EMERALD_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_DIAMOND_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_NETHERITE_BEACON.get()), (RenderType)RenderType.m_110463_());
        });
    }

    private void registerCreativeTab(CreativeModeTabEvent.Register event) {
        FERRET_ITEM_GROUP = Optional.of(event.registerCreativeModeTab(new ResourceLocation(MOD_ID, MOD_ID), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)net.minecraft.world.level.block.Blocks.f_50087_)).m_257941_((Component)Component.m_237115_((String)"itemGroup.libraryferret.libraryferret")).m_257501_((features, output) -> output.m_246601_(Stream.of((Item)Items.IRON_COIN.get(), (Item)Items.GOLD_COIN.get(), (Item)Items.EMERALD_COIN.get(), (Item)Items.DIAMOND_COIN.get(), (Item)Items.NETHERITE_COIN.get(), (Item)Blocks.ITEM_FAKE_IRON_BLOCK.get(), (Item)Blocks.ITEM_FAKE_GOLD_BLOCK.get(), (Item)Blocks.ITEM_FAKE_EMERALD_BLOCK.get(), (Item)Blocks.ITEM_FAKE_DIAMOND_BLOCK.get(), (Item)Blocks.ITEM_FAKE_NETHERITE_BLOCK.get(), (Item)Blocks.ITEM_UNBREAKABLE_IRON_BEACON.get(), (Item)Blocks.ITEM_UNBREAKABLE_GOLD_BEACON.get(), (Item)Blocks.ITEM_UNBREAKABLE_EMERALD_BEACON.get(), (Item)Blocks.ITEM_UNBREAKABLE_DIAMOND_BEACON.get(), (Item)Blocks.ITEM_UNBREAKABLE_NETHERITE_BEACON.get()).map(Item::m_7968_).toList()))));
    }

    public static boolean isLoaded() {
        return isLOADED;
    }

    public static <SP extends StructurePlacement> RegistryObject<StructurePlacementType<SP>> registerPlacementType(DeferredRegister<StructurePlacementType<?>> def, String identifier, Codec<SP> codec) {
        return def.register(identifier, () -> () -> codec);
    }
}

