/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.vertex.PoseStack;
import immersive_armors.client.render.entity.model.DecoModel;
import immersive_armors.client.render.entity.piece.Piece;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class ItemPiece
extends Piece {
    private final String attachTo;
    private final float x;
    private final float y;
    private final float z;
    private final float size;
    private final ItemStack stack;
    private final Quaternionf rotation;

    public ItemPiece(String to, float x, float y, float z, float size, ItemStack stack) {
        this(to, x, y, z, size, stack, null);
    }

    public ItemPiece(String to, float x, float y, float z, float size, ItemStack stack, @Nullable Quaternionf rotation) {
        this.attachTo = to;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.stack = stack;
        this.rotation = rotation;
    }

    @Override
    public <T extends LivingEntity, A extends HumanoidModel<T>> void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, float tickDelta, EquipmentSlot armorSlot, A armorModel) {
        matrices.m_85836_();
        DecoModel.getModelPart(armorModel, this.attachTo).m_104299_(matrices);
        matrices.m_252880_(this.x, this.y, this.z);
        matrices.m_85841_(this.size, -this.size, -this.size);
        if (this.rotation != null) {
            matrices.m_252781_(this.rotation);
        }
        Minecraft.m_91087_().m_91291_().m_269491_(entity, this.stack, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, entity.f_19853_, light, OverlayTexture.f_118083_, 0);
        matrices.m_85849_();
    }
}

