/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.data.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicChair
extends AbstractSittableBlock {
    private static final List<FurnitureBlock> WOOD_BASIC_CHAIRS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_BASIC_CHAIRS = new ArrayList<FurnitureBlock>();
    protected static final BooleanProperty TUCKED = BooleanProperty.m_61465_((String)"tucked");
    protected static final VoxelShape FACE_WEST = Shapes.m_83124_((VoxelShape)BasicChair.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)3.5, (double)8.0, (double)4.5), (VoxelShape[])new VoxelShape[]{BasicChair.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)3.5, (double)8.0, (double)13.5), BasicChair.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)13.5, (double)8.0, (double)4.5), BasicChair.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)13.5, (double)8.0, (double)13.5), BasicChair.m_49796_((double)0.32, (double)8.0, (double)1.6, (double)14.3, (double)10.49, (double)14.6), BasicChair.m_49796_((double)0.32, (double)8.0, (double)1.6, (double)2.65, (double)24.49, (double)14.6)});
    protected static final VoxelShape FACE_EAST = Shapes.m_83124_((VoxelShape)BasicChair.m_49796_((double)2.5, (double)0.0, (double)2.5, (double)5.0, (double)8.0, (double)5.0), (VoxelShape[])new VoxelShape[]{BasicChair.m_49796_((double)2.5, (double)0.0, (double)11.5, (double)5.0, (double)8.0, (double)14.0), BasicChair.m_49796_((double)12.5, (double)0.0, (double)2.5, (double)15.0, (double)8.0, (double)5.0), BasicChair.m_49796_((double)12.5, (double)0.0, (double)11.5, (double)15.0, (double)8.0, (double)14.0), BasicChair.m_49796_((double)1.65, (double)8.0, (double)1.4, (double)15.66, (double)10.49, (double)14.4), BasicChair.m_49796_((double)13.33, (double)8.0, (double)1.4, (double)15.66, (double)24.49, (double)14.4)});
    protected static final VoxelShape FACE_NORTH = Shapes.m_83124_((VoxelShape)BasicChair.m_49796_((double)2.5, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)3.5), (VoxelShape[])new VoxelShape[]{BasicChair.m_49796_((double)2.5, (double)0.0, (double)11.0, (double)5.0, (double)8.0, (double)13.5), BasicChair.m_49796_((double)11.5, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)3.5), BasicChair.m_49796_((double)11.5, (double)0.0, (double)11.0, (double)14.0, (double)8.0, (double)13.5), BasicChair.m_49796_((double)1.39, (double)8.0, (double)0.32, (double)14.4, (double)10.49, (double)14.32), BasicChair.m_49796_((double)1.39, (double)8.0, (double)0.32, (double)14.4, (double)24.49, (double)2.65)});
    protected static final VoxelShape FACE_SOUTH = Shapes.m_83124_((VoxelShape)BasicChair.m_49796_((double)2.0, (double)0.0, (double)2.5, (double)4.5, (double)8.0, (double)5.0), (VoxelShape[])new VoxelShape[]{BasicChair.m_49796_((double)2.0, (double)0.0, (double)12.5, (double)4.5, (double)8.0, (double)15.0), BasicChair.m_49796_((double)11.0, (double)0.0, (double)2.5, (double)13.5, (double)8.0, (double)5.0), BasicChair.m_49796_((double)11.0, (double)0.0, (double)12.5, (double)13.5, (double)8.0, (double)15.0), BasicChair.m_49796_((double)1.61, (double)8.0, (double)1.65, (double)14.66, (double)10.49, (double)15.67), BasicChair.m_49796_((double)1.61, (double)8.0, (double)13.4, (double)14.66, (double)24.49, (double)15.67)});
    protected static final VoxelShape FACE_NORTH_TUCKED = BasicChair.tuckShape(Direction.NORTH, FACE_NORTH);
    protected static final VoxelShape FACE_SOUTH_TUCKED = BasicChair.tuckShape(Direction.SOUTH, FACE_SOUTH);
    protected static final VoxelShape FACE_EAST_TUCKED = BasicChair.tuckShape(Direction.EAST, FACE_EAST);
    protected static final VoxelShape FACE_WEST_TUCKED = BasicChair.tuckShape(Direction.WEST, FACE_WEST);

    public BasicChair(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        this.height = 0.36f;
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(BasicChair.class)) {
            WOOD_BASIC_CHAIRS.add(new FurnitureBlock((Block)this, "chair"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(BasicChair.class)) {
            STONE_BASIC_CHAIRS.add(new FurnitureBlock((Block)this, "chair"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodBasicChairs() {
        return WOOD_BASIC_CHAIRS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneBasicChairs() {
        return STONE_BASIC_CHAIRS.stream();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{TUCKED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        if (((Boolean)state.m_61143_((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return switch (dir) {
            case Direction.WEST -> FACE_WEST;
            case Direction.NORTH -> FACE_NORTH;
            case Direction.SOUTH -> FACE_SOUTH;
            default -> FACE_EAST;
        };
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static VoxelShape tuckShape(Direction from, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        switch (from) {
            case NORTH: {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minY, (double)(minZ + 0.5), (double)maxX, (double)maxY, (double)(maxZ + 0.5)));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.m_83040_();
                break;
            }
            case SOUTH: {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minY, (double)(minZ - 0.5), (double)maxX, (double)maxY, (double)(maxZ - 0.5)));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.m_83040_();
                break;
            }
            case WEST: {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(minX + 0.5), (double)minY, (double)minZ, (double)(maxX + 0.5), (double)maxY, (double)maxZ));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.m_83040_();
                break;
            }
            default: {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(minX - 0.5), (double)minY, (double)minZ, (double)(maxX - 0.5), (double)maxY, (double)maxZ));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.m_83040_();
            }
        }
        return buffer[0];
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canTuck(world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()))) && ((Boolean)state.m_61143_((Property)TUCKED)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean canTuck(BlockState state) {
        return state.m_204336_(Tags.getTuckableBlocks());
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_() && this.canTuck(world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_())))) {
            if (((Boolean)state.m_61143_((Property)TUCKED)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
            } else {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(true)));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }
}

