/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicTableShape;
import com.unlikepaladin.pfm.compat.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicTable
extends Block {
    private final Block baseBlock;
    public static final EnumProperty<BasicTableShape> SHAPE = EnumProperty.m_61587_((String)"shape", BasicTableShape.class);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_BASIC_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_BASIC_TABLES = new ArrayList<FurnitureBlock>();
    static final VoxelShape TABLE_BASIC_NORTH = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)12.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)12.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)14.0)});
    static final VoxelShape TABLE_BASIC_EAST = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)4.0, (double)14.0, (double)13.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)14.0, (double)13.0), BasicTable.m_49796_((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)2.0, (double)13.0)});
    static final VoxelShape TABLE_BASIC = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)14.0, (double)4.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)12.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)14.0)});
    static final VoxelShape TABLE_BASIC_NORTH_WEST = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)12.0, (double)0.0, (double)3.0, (double)14.0, (double)14.0, (double)5.0), BasicTable.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)12.0, (double)2.0, (double)5.0)});
    static final VoxelShape TABLE_BASIC_NORTH_EAST = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)3.0, (double)0.0, (double)12.0, (double)5.0, (double)14.0, (double)14.0), BasicTable.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)12.0)});
    static final VoxelShape TABLE_BASIC_MIDDLE = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    static final VoxelShape TABLE_BASIC_NORTH_SOUTH = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)16.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0)});
    static final VoxelShape TABLE_BASIC_LEG = Shapes.m_83110_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)BasicTable.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0, (double)13.0));
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_WEST = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)12.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0)});
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_EAST = Shapes.m_83124_((VoxelShape)BasicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicTable.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)14.0), BasicTable.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)12.0), BasicTable.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0)});
    static final VoxelShape TABLE_BASIC_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC);
    static final VoxelShape TABLE_BASIC_EAST_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_EAST);
    static final VoxelShape TABLE_BASIC_NORTH_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_NORTH);
    static final VoxelShape TABLE_BASIC_NORTH_FACING_SOUTH = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_BASIC_NORTH);
    static final VoxelShape TABLE_BASIC_EAST_FACING_SOUTH = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_BASIC_EAST);
    static final VoxelShape TABLE_BASIC_EAST_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_EAST);
    static final VoxelShape TABLE_BASIC_NORTH_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_NORTH);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_FACING_EAST = BasicTable.rotateShape(Direction.WEST, Direction.EAST, TABLE_BASIC_NORTH_WEST);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_NORTH_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_NORTH_WEST);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_NORTH_EAST);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_NORTH_WEST);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_NORTH_EAST);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_FACING_SOUTH = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_BASIC_NORTH_EAST);
    static final VoxelShape TABLE_BASIC_NORTH_SOUTH_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_NORTH_SOUTH);
    static final VoxelShape TABLE_BASIC_LEG_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_LEG);
    static final VoxelShape TABLE_BASIC_LEG_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_LEG);
    static final VoxelShape TABLE_BASIC_LEG_FACING_SOUTH = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_BASIC_LEG);
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_EAST_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_CORNER_NORTH_EAST);
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_WEST_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_CORNER_NORTH_WEST);
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_WEST_FACING_SOUTH = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_BASIC_CORNER_NORTH_WEST);
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_EAST_FACING_EAST = BasicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_BASIC_CORNER_NORTH_EAST);
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_EAST_FACING_SOUTH = BasicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_BASIC_CORNER_NORTH_EAST);
    static final VoxelShape TABLE_BASIC_CORNER_NORTH_WEST_FACING_WEST = BasicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_BASIC_CORNER_NORTH_WEST);

    public BasicTable(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SINGLE))).m_61124_(AXIS, (Comparable)Direction.Axis.X));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(BasicTable.class)) {
            WOOD_BASIC_TABLES.add(new FurnitureBlock(this, "table_basic"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(BasicTable.class)) {
            STONE_BASIC_TABLES.add(new FurnitureBlock(this, "table_basic"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodBasicTables() {
        return WOOD_BASIC_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneBasicTables() {
        return STONE_BASIC_TABLES.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{AXIS});
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122479_() ? this.getShape(state, (BlockGetter)world, pos) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        Direction.Axis facing = ctx.m_8125_().m_122434_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)facing);
        return this.getShape(blockState, (BlockGetter)world, blockPos);
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    boolean canConnect(BlockState blockState) {
        PaladinFurnitureMod.getPFMConfig();
        return PaladinFurnitureModConfig.doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof BasicTable : blockState.m_60734_() == this;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    private BlockState getShape(BlockState state, BlockGetter world, BlockPos pos) {
        boolean cornerSouthWest;
        Direction.Axis dir = (Direction.Axis)state.m_61143_(AXIS);
        boolean north = false;
        boolean east = false;
        boolean west = false;
        boolean south = false;
        if (this.canConnect(world.m_8055_(pos.m_122012_())) && world.m_8055_(pos.m_122012_()).m_61143_(AXIS) == dir) {
            north = this.canConnect(world.m_8055_(pos.m_122012_()));
        }
        if (this.canConnect(world.m_8055_(pos.m_122029_())) && world.m_8055_(pos.m_122029_()).m_61143_(AXIS) == dir) {
            east = this.canConnect(world.m_8055_(pos.m_122029_()));
        }
        if (this.canConnect(world.m_8055_(pos.m_122024_())) && world.m_8055_(pos.m_122024_()).m_61143_(AXIS) == dir) {
            west = this.canConnect(world.m_8055_(pos.m_122024_()));
        }
        if (this.canConnect(world.m_8055_(pos.m_122019_())) && world.m_8055_(pos.m_122019_()).m_61143_(AXIS) == dir) {
            south = this.canConnect(world.m_8055_(pos.m_122019_()));
        }
        boolean cornerNorthWest = north && west && !this.canConnect(world.m_8055_(pos.m_122012_().m_122024_()));
        boolean cornerNorthEast = north && east && !this.canConnect(world.m_8055_(pos.m_122012_().m_122029_()));
        boolean cornerSouthEast = south && east && !this.canConnect(world.m_8055_(pos.m_122019_().m_122029_()));
        boolean bl = cornerSouthWest = south && west && !this.canConnect(world.m_8055_(pos.m_122019_().m_122024_()));
        if (north && south && east && west && (cornerNorthEast && cornerSouthEast || cornerSouthWest && cornerNorthWest)) {
            if (north && south && east && west && cornerSouthWest && cornerNorthWest) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_EDGE));
            }
            if (north && south && east && west && cornerNorthEast && cornerSouthEast) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.WEST_EDGE));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_SOUTH));
        }
        if (north && south && east && west && !cornerNorthEast && !cornerSouthEast && !cornerNorthWest && !cornerSouthWest) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.ALL));
        }
        if (north && south && east && west && !cornerNorthEast && !cornerSouthEast && cornerNorthWest && !cornerSouthWest) {
            if (dir.equals((Object)Direction.Axis.X)) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_EAST));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_WEST));
        }
        if (north && south && east && west && cornerNorthEast && !cornerSouthEast && !cornerNorthWest && !cornerSouthWest) {
            if (dir.equals((Object)Direction.Axis.X)) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_WEST));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_EAST));
        }
        if (north && south && east && west && !cornerNorthEast && !cornerSouthEast && !cornerNorthWest && cornerSouthWest) {
            if (dir.equals((Object)Direction.Axis.X)) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_EAST));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_WEST));
        }
        if (north && south && east && west && !cornerNorthEast && cornerSouthEast && !cornerNorthWest && !cornerSouthWest) {
            if (dir.equals((Object)Direction.Axis.X)) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_WEST));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_EAST));
        }
        if (cornerNorthEast && cornerSouthEast) {
            if (north && south && east && west) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_EDGE));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_SOUTH));
        }
        if (cornerNorthWest && cornerSouthWest) {
            if (north && south && east && west) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_EDGE));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_SOUTH));
        }
        if (cornerNorthEast && cornerNorthWest) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_WEST));
        }
        if (cornerSouthWest && cornerSouthEast) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_WEST));
        }
        if (cornerNorthEast) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.CORNER_NORTH_EAST));
        }
        if (cornerNorthWest) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.CORNER_NORTH_WEST));
        }
        if (cornerSouthEast) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.CORNER_SOUTH_EAST));
        }
        if (cornerSouthWest) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.CORNER_SOUTH_WEST));
        }
        if (north && south && !east && !west) {
            if (north && south && east && west) {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_EDGE));
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_SOUTH));
        }
        if (!north && !south && east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_WEST));
        }
        if (!north && south && east && !west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_EAST));
        }
        if (!north && south && !east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_WEST));
        }
        if (north && !south && !east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_WEST));
        }
        if (north && !south && east && !west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_EAST));
        }
        if (north && !south && east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH_EDGE));
        }
        if (!north && south && east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH_EDGE));
        }
        if (north && south && east && !west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST_EDGE));
        }
        if (north && south && !east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.WEST_EDGE));
        }
        if (north && !south && !east && !west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.NORTH));
        }
        if (!north && south && !east && !west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SOUTH));
        }
        if (!north && !south && east && !west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.EAST));
        }
        if (!north && !south && !east && west) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.WEST));
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BasicTableShape.SINGLE));
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction.Axis dir = (Direction.Axis)state.m_61143_(AXIS);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.Axis.X);
        BasicTableShape blockShape = (BasicTableShape)((Object)state.m_61143_(SHAPE));
        if (dirNorthOrSouth) {
            return switch (blockShape) {
                case BasicTableShape.NORTH -> TABLE_BASIC_NORTH;
                case BasicTableShape.WEST -> TABLE_BASIC_EAST_FACING_WEST;
                case BasicTableShape.EAST -> TABLE_BASIC_EAST_FACING_EAST;
                case BasicTableShape.SOUTH -> TABLE_BASIC_NORTH_FACING_SOUTH;
                case BasicTableShape.CORNER_NORTH_EAST -> TABLE_BASIC_CORNER_NORTH_EAST;
                case BasicTableShape.NORTH_SOUTH -> TABLE_BASIC_NORTH_SOUTH;
                case BasicTableShape.CORNER_NORTH_WEST -> TABLE_BASIC_CORNER_NORTH_WEST;
                case BasicTableShape.CORNER_SOUTH_EAST -> TABLE_BASIC_CORNER_NORTH_WEST_FACING_SOUTH;
                case BasicTableShape.CORNER_SOUTH_WEST -> TABLE_BASIC_CORNER_NORTH_EAST_FACING_SOUTH;
                case BasicTableShape.EAST_EDGE -> TABLE_BASIC_LEG_FACING_EAST;
                case BasicTableShape.WEST_EDGE -> TABLE_BASIC_LEG_FACING_WEST;
                case BasicTableShape.NORTH_EDGE, BasicTableShape.SOUTH_EDGE, BasicTableShape.ALL, BasicTableShape.EAST_WEST -> TABLE_BASIC_MIDDLE;
                case BasicTableShape.NORTH_EAST -> TABLE_BASIC_NORTH_EAST;
                case BasicTableShape.NORTH_WEST -> TABLE_BASIC_NORTH_WEST_NORTH_FACING_EAST;
                case BasicTableShape.SOUTH_EAST -> TABLE_BASIC_NORTH_WEST_FACING_WEST;
                case BasicTableShape.SOUTH_WEST -> TABLE_BASIC_NORTH_EAST_FACING_SOUTH;
                default -> TABLE_BASIC;
            };
        }
        return switch (blockShape) {
            case BasicTableShape.NORTH -> TABLE_BASIC_EAST;
            case BasicTableShape.WEST -> TABLE_BASIC_NORTH_FACING_WEST;
            case BasicTableShape.EAST -> TABLE_BASIC_NORTH_FACING_EAST;
            case BasicTableShape.SOUTH -> TABLE_BASIC_EAST_FACING_SOUTH;
            case BasicTableShape.CORNER_NORTH_EAST -> TABLE_BASIC_CORNER_NORTH_WEST_FACING_EAST;
            case BasicTableShape.EAST_WEST -> TABLE_BASIC_NORTH_SOUTH_FACING_EAST;
            case BasicTableShape.CORNER_NORTH_WEST -> TABLE_BASIC_CORNER_NORTH_EAST_FACING_WEST;
            case BasicTableShape.CORNER_SOUTH_EAST -> TABLE_BASIC_CORNER_NORTH_EAST_FACING_EAST;
            case BasicTableShape.CORNER_SOUTH_WEST -> TABLE_BASIC_CORNER_NORTH_WEST_FACING_WEST;
            case BasicTableShape.NORTH_EDGE -> TABLE_BASIC_LEG;
            case BasicTableShape.SOUTH_EDGE -> TABLE_BASIC_LEG_FACING_SOUTH;
            case BasicTableShape.NORTH_SOUTH, BasicTableShape.EAST_EDGE, BasicTableShape.WEST_EDGE, BasicTableShape.ALL -> TABLE_BASIC_MIDDLE;
            case BasicTableShape.NORTH_EAST -> TABLE_BASIC_NORTH_WEST_FACING_EAST;
            case BasicTableShape.NORTH_WEST -> TABLE_BASIC_NORTH_EAST_FACING_WEST;
            case BasicTableShape.SOUTH_EAST -> TABLE_BASIC_NORTH_EAST_FACING_EAST;
            case BasicTableShape.SOUTH_WEST -> TABLE_BASIC_NORTH_WEST;
            default -> TABLE_BASIC_FACING_EAST;
        };
    }
}

