/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.LogTable;
import com.unlikepaladin.pfm.blocks.MiddleShape;
import com.unlikepaladin.pfm.blocks.SimpleBed;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClassicBed
extends SimpleBed {
    private static final List<FurnitureBlock> CLASSIC_BEDS = new ArrayList<FurnitureBlock>();
    static final VoxelShape HEAD = Shapes.m_83124_((VoxelShape)ClassicBed.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape[])new VoxelShape[]{ClassicBed.m_49796_((double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)9.0, (double)16.0), ClassicBed.m_49796_((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)10.0, (double)11.0)});
    static final VoxelShape HEAD_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD);
    static final VoxelShape HEAD_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD);
    static final VoxelShape HEAD_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD);
    static final VoxelShape FOOT = Shapes.m_83110_((VoxelShape)ClassicBed.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.0, (double)13.0), (VoxelShape)ClassicBed.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)10.0, (double)15.0));
    static final VoxelShape FOOT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT);
    static final VoxelShape FOOT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT);
    static final VoxelShape FOOT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT);
    static final VoxelShape FOOT_FOOT_R = ClassicBed.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)11.0, (double)16.0);
    static final VoxelShape FOOT_FOOT_L = ClassicBed.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)11.0, (double)16.0);
    static final VoxelShape FOOT_HEAD_R = ClassicBed.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    static final VoxelShape FOOT_HEAD_L = ClassicBed.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
    static final VoxelShape HEAD_SINGLE = Shapes.m_83124_((VoxelShape)HEAD, (VoxelShape[])new VoxelShape[]{FOOT_HEAD_L, FOOT_HEAD_R});
    static final VoxelShape HEAD_SINGLE_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_SINGLE);
    static final VoxelShape HEAD_SINGLE_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_SINGLE);
    static final VoxelShape HEAD_SINGLE_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_SINGLE);
    static final VoxelShape FOOT_SINGLE = Shapes.m_83124_((VoxelShape)FOOT, (VoxelShape[])new VoxelShape[]{FOOT_FOOT_L, FOOT_FOOT_R});
    static final VoxelShape FOOT_SINGLE_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_SINGLE);
    static final VoxelShape FOOT_SINGLE_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_SINGLE);
    static final VoxelShape FOOT_SINGLE_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_SINGLE);
    static final VoxelShape HEAD_LEFT = Shapes.m_83110_((VoxelShape)HEAD, (VoxelShape)FOOT_HEAD_L);
    static final VoxelShape HEAD_LEFT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_LEFT);
    static final VoxelShape HEAD_LEFT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_LEFT);
    static final VoxelShape HEAD_LEFT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_LEFT);
    static final VoxelShape FOOT_LEFT = Shapes.m_83110_((VoxelShape)FOOT, (VoxelShape)FOOT_FOOT_L);
    static final VoxelShape FOOT_LEFT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_LEFT);
    static final VoxelShape FOOT_LEFT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_LEFT);
    static final VoxelShape FOOT_LEFT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_LEFT);
    static final VoxelShape HEAD_RIGHT = Shapes.m_83110_((VoxelShape)HEAD, (VoxelShape)FOOT_HEAD_R);
    static final VoxelShape HEAD_RIGHT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD_RIGHT);
    static final VoxelShape HEAD_RIGHT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, HEAD_RIGHT);
    static final VoxelShape HEAD_RIGHT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, HEAD_RIGHT);
    static final VoxelShape FOOT_RIGHT = Shapes.m_83110_((VoxelShape)FOOT, (VoxelShape)FOOT_FOOT_R);
    static final VoxelShape FOOT_RIGHT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_RIGHT);
    static final VoxelShape FOOT_RIGHT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_RIGHT);
    static final VoxelShape FOOT_RIGHT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_RIGHT);
    static final VoxelShape FOOT_BUNK_LEFT = ClassicBed.m_49796_((double)0.0, (double)-5.0, (double)13.0, (double)3.0, (double)0.0, (double)16.0);
    static final VoxelShape FOOT_BUNK_LEFT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_BUNK_LEFT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_BUNK_LEFT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_BUNK_RIGHT = ClassicBed.m_49796_((double)13.0, (double)-5.0, (double)13.0, (double)16.0, (double)0.0, (double)16.0);
    static final VoxelShape FOOT_BUNK_RIGHT_SOUTH = LogTable.rotateShape(Direction.NORTH, Direction.SOUTH, FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_BUNK_RIGHT_EAST = LogTable.rotateShape(Direction.NORTH, Direction.EAST, FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_BUNK_RIGHT_WEST = LogTable.rotateShape(Direction.NORTH, Direction.WEST, FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_SINGLE_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT, FOOT_BUNK_RIGHT});
    static final VoxelShape FOOT_SINGLE_SOUTH_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE_SOUTH, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT_SOUTH, FOOT_BUNK_RIGHT_SOUTH});
    static final VoxelShape FOOT_SINGLE_EAST_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE_EAST, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT_EAST, FOOT_BUNK_RIGHT_EAST});
    static final VoxelShape FOOT_SINGLE_WEST_BUNK = Shapes.m_83124_((VoxelShape)FOOT_SINGLE_WEST, (VoxelShape[])new VoxelShape[]{FOOT_BUNK_LEFT_WEST, FOOT_BUNK_RIGHT_WEST});
    static final VoxelShape FOOT_LEFT_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT, (VoxelShape)FOOT_BUNK_LEFT);
    static final VoxelShape FOOT_LEFT_SOUTH_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT_SOUTH, (VoxelShape)FOOT_BUNK_LEFT_SOUTH);
    static final VoxelShape FOOT_LEFT_EAST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT_EAST, (VoxelShape)FOOT_BUNK_LEFT_EAST);
    static final VoxelShape FOOT_LEFT_WEST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_LEFT_WEST, (VoxelShape)FOOT_BUNK_LEFT_WEST);
    static final VoxelShape FOOT_RIGHT_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT, (VoxelShape)FOOT_BUNK_RIGHT);
    static final VoxelShape FOOT_RIGHT_SOUTH_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT_SOUTH, (VoxelShape)FOOT_BUNK_RIGHT_SOUTH);
    static final VoxelShape FOOT_RIGHT_EAST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT_EAST, (VoxelShape)FOOT_BUNK_RIGHT_EAST);
    static final VoxelShape FOOT_RIGHT_WEST_BUNK = Shapes.m_83110_((VoxelShape)FOOT_RIGHT_WEST, (VoxelShape)FOOT_BUNK_RIGHT_WEST);

    public ClassicBed(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
        if (this.getClass().isAssignableFrom(ClassicBed.class)) {
            String bedColor = color.m_41065_();
            CLASSIC_BEDS.add(new FurnitureBlock((Block)this, bedColor + "_classic_bed"));
        }
    }

    public static Stream<FurnitureBlock> streamClassicBeds() {
        return CLASSIC_BEDS.stream();
    }

    @Override
    public boolean isBed(LevelAccessor world, BlockPos pos, Direction direction, Direction bedDirection, BlockState originalState) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        if (state.m_60734_().getClass().isAssignableFrom(ClassicBed.class) && state.m_60734_() instanceof ClassicBed && state.m_61143_((Property)f_49440_) == originalState.m_61143_((Property)f_49440_)) {
            Direction sourceDirection = (Direction)state.m_61143_((Property)f_54117_);
            return sourceDirection.equals((Object)bedDirection);
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        BedPart bedPart = (BedPart)state.m_61143_((Property)f_49440_);
        MiddleShape middleShape = (MiddleShape)((Object)state.m_61143_((Property)SHAPE));
        boolean bunk = (Boolean)state.m_61143_((Property)BUNK);
        if (bedPart == BedPart.FOOT && bunk) {
            switch (middleShape) {
                case SINGLE: {
                    switch (dir) {
                        case NORTH: {
                            return FOOT_SINGLE_BUNK;
                        }
                        case EAST: {
                            return FOOT_SINGLE_EAST_BUNK;
                        }
                        case WEST: {
                            return FOOT_SINGLE_WEST_BUNK;
                        }
                    }
                    return FOOT_SINGLE_SOUTH_BUNK;
                }
                case MIDDLE: {
                    switch (dir) {
                        case NORTH: {
                            return FOOT;
                        }
                        case EAST: {
                            return FOOT_EAST;
                        }
                        case WEST: {
                            return FOOT_WEST;
                        }
                    }
                    return FOOT_SOUTH;
                }
                case RIGHT: {
                    switch (dir) {
                        case NORTH: {
                            return FOOT_RIGHT_BUNK;
                        }
                        case EAST: {
                            return FOOT_RIGHT_EAST_BUNK;
                        }
                        case WEST: {
                            return FOOT_RIGHT_WEST_BUNK;
                        }
                    }
                    return FOOT_RIGHT_SOUTH_BUNK;
                }
            }
            switch (dir) {
                case NORTH: {
                    return FOOT_LEFT_BUNK;
                }
                case EAST: {
                    return FOOT_LEFT_EAST_BUNK;
                }
                case WEST: {
                    return FOOT_LEFT_WEST_BUNK;
                }
            }
            return FOOT_LEFT_SOUTH_BUNK;
        }
        switch (middleShape) {
            case MIDDLE: {
                switch (dir) {
                    case NORTH: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD;
                        }
                        return FOOT;
                    }
                    case EAST: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_EAST;
                        }
                        return FOOT_EAST;
                    }
                    case WEST: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_WEST;
                        }
                        return FOOT_WEST;
                    }
                }
                if (bedPart == BedPart.HEAD) {
                    return HEAD_SOUTH;
                }
                return FOOT_SOUTH;
            }
            case SINGLE: {
                switch (dir) {
                    case NORTH: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_SINGLE;
                        }
                        return FOOT_SINGLE;
                    }
                    case EAST: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_SINGLE_EAST;
                        }
                        return FOOT_SINGLE_EAST;
                    }
                    case WEST: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_SINGLE_WEST;
                        }
                        return FOOT_SINGLE_WEST;
                    }
                }
                if (bedPart == BedPart.HEAD) {
                    return HEAD_SINGLE_SOUTH;
                }
                return FOOT_SINGLE_SOUTH;
            }
            case RIGHT: {
                switch (dir) {
                    case NORTH: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_RIGHT;
                        }
                        return FOOT_RIGHT;
                    }
                    case EAST: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_RIGHT_EAST;
                        }
                        return FOOT_RIGHT_EAST;
                    }
                    case WEST: {
                        if (bedPart == BedPart.HEAD) {
                            return HEAD_RIGHT_WEST;
                        }
                        return FOOT_RIGHT_WEST;
                    }
                }
                if (bedPart == BedPart.HEAD) {
                    return HEAD_RIGHT_SOUTH;
                }
                return FOOT_RIGHT_SOUTH;
            }
        }
        switch (dir) {
            case NORTH: {
                if (bedPart == BedPart.HEAD) {
                    return HEAD_LEFT;
                }
                return FOOT_LEFT;
            }
            case EAST: {
                if (bedPart == BedPart.HEAD) {
                    return HEAD_LEFT_EAST;
                }
                return FOOT_LEFT_EAST;
            }
            case WEST: {
                if (bedPart == BedPart.HEAD) {
                    return HEAD_LEFT_WEST;
                }
                return FOOT_LEFT_WEST;
            }
        }
        if (bedPart == BedPart.HEAD) {
            return HEAD_LEFT_SOUTH;
        }
        return FOOT_LEFT_SOUTH;
    }
}

