/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.compat.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClassicTable
extends Block {
    private final Block baseBlock;
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final List<FurnitureBlock> WOOD_CLASSIC_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CLASSIC_TABLES = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    static final VoxelShape TABLE_CLASSIC = Shapes.m_83124_((VoxelShape)ClassicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicTable.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), ClassicTable.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), ClassicTable.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)14.0, (double)4.0), ClassicTable.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)14.0)});
    static final VoxelShape TABLE_CLASSIC_MIDDLE = Shapes.m_83124_((VoxelShape)ClassicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    static final VoxelShape TABLE_CLASSIC_TWO = Shapes.m_83124_((VoxelShape)ClassicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicTable.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)15.0, (double)14.0), ClassicTable.m_49796_((double)13.0, (double)0.0, (double)2.0, (double)15.0, (double)15.0, (double)4.0)});
    static final VoxelShape TABLE_CLASSIC_ONE = Shapes.m_83110_((VoxelShape)ClassicTable.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)ClassicTable.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)15.0, (double)15.0));
    static final VoxelShape TABLE_CLASSIC_ONE_WEST = ClassicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_CLASSIC_ONE);
    static final VoxelShape TABLE_CLASSIC_MIDDLE_SOUTH = ClassicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_CLASSIC_MIDDLE);
    static final VoxelShape TABLE_CLASSIC_ONE_SOUTH = ClassicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_CLASSIC_ONE);
    static final VoxelShape TABLE_CLASSIC_ONE_EAST = ClassicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_CLASSIC_ONE);
    static final VoxelShape TABLE_CLASSIC_TWO_SOUTH = ClassicTable.rotateShape(Direction.NORTH, Direction.SOUTH, TABLE_CLASSIC_TWO);
    static final VoxelShape TABLE_CLASSIC_TWO_WEST = ClassicTable.rotateShape(Direction.NORTH, Direction.WEST, TABLE_CLASSIC_TWO);
    static final VoxelShape TABLE_CLASSIC_TWO_EAST = ClassicTable.rotateShape(Direction.NORTH, Direction.EAST, TABLE_CLASSIC_TWO);

    public ClassicTable(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(ClassicTable.class)) {
            WOOD_CLASSIC_TABLES.add(new FurnitureBlock(this, "table_classic"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicTable.class)) {
            STONE_CLASSIC_TABLES.add(new FurnitureBlock(this, "table_classic"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodClassicTables() {
        return WOOD_CLASSIC_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneClassicTables() {
        return STONE_CLASSIC_TABLES.stream();
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{NORTH});
        stateManager.m_61104_(new Property[]{EAST});
        stateManager.m_61104_(new Property[]{WEST});
        stateManager.m_61104_(new Property[]{SOUTH});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122479_() ? this.getShape(state, (BlockGetter)world, pos) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        BlockState blockState = this.m_49966_();
        return this.getShape(blockState, (BlockGetter)world, blockPos);
    }

    boolean canConnect(BlockState blockState) {
        PaladinFurnitureMod.getPFMConfig();
        return PaladinFurnitureModConfig.doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof ClassicTable : blockState.m_60734_() == this;
    }

    private BlockState getShape(BlockState state, BlockGetter world, BlockPos pos) {
        boolean north = false;
        boolean east = false;
        boolean west = false;
        boolean south = false;
        if (this.canConnect(world.m_8055_(pos.m_122012_()))) {
            north = this.canConnect(world.m_8055_(pos.m_122012_()));
        }
        if (this.canConnect(world.m_8055_(pos.m_122029_()))) {
            east = this.canConnect(world.m_8055_(pos.m_122029_()));
        }
        if (this.canConnect(world.m_8055_(pos.m_122024_()))) {
            west = this.canConnect(world.m_8055_(pos.m_122024_()));
        }
        if (this.canConnect(world.m_8055_(pos.m_122019_()))) {
            south = this.canConnect(world.m_8055_(pos.m_122019_()));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        boolean north = (Boolean)state.m_61143_((Property)NORTH);
        boolean east = (Boolean)state.m_61143_((Property)EAST);
        boolean west = (Boolean)state.m_61143_((Property)WEST);
        boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        if (!(north || south || west || east)) {
            return TABLE_CLASSIC;
        }
        if (south && west && !north && !east) {
            return TABLE_CLASSIC_ONE_WEST;
        }
        if (east && west && south && !north) {
            return TABLE_CLASSIC_MIDDLE_SOUTH;
        }
        if (north && west && south && !east) {
            return TABLE_CLASSIC_MIDDLE;
        }
        if (north && west && east && !south) {
            return TABLE_CLASSIC_MIDDLE;
        }
        if (north && south && east && !west) {
            return TABLE_CLASSIC_MIDDLE;
        }
        if (north && west && !east && !south) {
            return TABLE_CLASSIC_ONE;
        }
        if (east && south && !west && !north) {
            return TABLE_CLASSIC_ONE_SOUTH;
        }
        if (east && north && !west && !south) {
            return TABLE_CLASSIC_ONE_EAST;
        }
        if (east && north && west && south) {
            return TABLE_CLASSIC_MIDDLE;
        }
        if (east && west && !north && !south) {
            return TABLE_CLASSIC_MIDDLE;
        }
        if (north && south && !east && !west) {
            return TABLE_CLASSIC_MIDDLE;
        }
        if (east && !north && !south && !west) {
            return TABLE_CLASSIC_TWO_SOUTH;
        }
        if (west && !north && !south && !east) {
            return TABLE_CLASSIC_TWO;
        }
        if (south && !north && !west && !east) {
            return TABLE_CLASSIC_TWO_WEST;
        }
        if (north && !south && !west && !east) {
            return TABLE_CLASSIC_TWO_EAST;
        }
        return Shapes.m_83144_();
    }
}

