/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.Fridge;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWEntity;
import com.unlikepaladin.pfm.blocks.IronFreezer;
import com.unlikepaladin.pfm.blocks.KitchenDrawer;
import com.unlikepaladin.pfm.blocks.blockentities.FreezerBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Freezer
extends HorizontalFacingBlockWEntity {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private Supplier<Block> fridge;
    private static final List<FurnitureBlock> FREEZERS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape FREEZER = Shapes.m_83124_((VoxelShape)Freezer.m_49796_((double)0.5, (double)-16.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Freezer.m_49796_((double)0.5, (double)5.0, (double)2.0, (double)14.83, (double)16.0, (double)3.1), Freezer.m_49796_((double)13.0, (double)5.19, (double)0.09, (double)14.0, (double)15.19, (double)1.09), Freezer.m_49796_((double)13.0, (double)5.19, (double)0.98, (double)14.0, (double)6.19, (double)2.98), Freezer.m_49796_((double)13.0, (double)14.19, (double)1.06, (double)14.0, (double)15.19, (double)3.06)});
    protected static final VoxelShape FREEZER_OPEN = Shapes.m_83124_((VoxelShape)Freezer.m_49796_((double)0.5, (double)-16.0, (double)2.8, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Freezer.m_49796_((double)0.5, (double)5.0, (double)-11.29, (double)1.5, (double)16.0, (double)3.05), Freezer.m_49796_((double)-1.41, (double)5.19, (double)-10.45, (double)-0.41, (double)15.19, (double)-9.45), Freezer.m_49796_((double)-0.52, (double)5.19, (double)-10.45, (double)1.48, (double)6.19, (double)-9.45), Freezer.m_49796_((double)-0.44, (double)14.19, (double)-10.45, (double)1.26, (double)15.19, (double)-9.45)});
    protected static final VoxelShape FREEZER_SOUTH = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, FREEZER);
    protected static final VoxelShape FREEZER_SOUTH_OPEN = KitchenDrawer.rotateShape(Direction.NORTH, Direction.SOUTH, FREEZER_OPEN);
    protected static final VoxelShape FREEZER_EAST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, FREEZER);
    protected static final VoxelShape FREEZER_EAST_OPEN = KitchenDrawer.rotateShape(Direction.NORTH, Direction.EAST, FREEZER_OPEN);
    protected static final VoxelShape FREEZER_WEST = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, FREEZER);
    protected static final VoxelShape FREEZER_WEST_OPEN = KitchenDrawer.rotateShape(Direction.NORTH, Direction.WEST, FREEZER_OPEN);

    public Freezer(BlockBehaviour.Properties settings, Supplier<Block> fridge) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.fridge = fridge;
        this.baseBlock = this.baseBlockState.m_60734_();
        FREEZERS.add(new FurnitureBlock((Block)this, "freezer_"));
    }

    public static Stream<FurnitureBlock> streamFreezers() {
        return FREEZERS.stream();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MenuProvider screenHandlerFactory;
        if (!world.f_46443_ && (screenHandlerFactory = state.m_60750_(world, pos)) != null) {
            player.m_36220_(Statistics.FREEZER_OPENED);
            player.m_5893_(screenHandlerFactory);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return this.fridge.get().m_7397_(world, pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122434_() == Direction.Axis.Y != (direction == Direction.UP) && !(neighborState.m_60734_() instanceof Fridge)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60713_(state.m_60734_()) || blockState.m_60734_() instanceof Fridge) {
            BlockState blockState2 = blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        if (blockPos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(blockPos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Boolean open = (Boolean)state.m_61143_((Property)OPEN);
        switch (dir) {
            case NORTH: {
                if (open.booleanValue()) {
                    return FREEZER_SOUTH_OPEN;
                }
                return FREEZER_SOUTH;
            }
            case SOUTH: {
                if (open.booleanValue()) {
                    return FREEZER_OPEN;
                }
                return FREEZER;
            }
            case EAST: {
                if (open.booleanValue()) {
                    return FREEZER_WEST_OPEN;
                }
                return FREEZER_WEST;
            }
        }
        if (open.booleanValue()) {
            return FREEZER_EAST_OPEN;
        }
        return FREEZER_EAST;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60734_() instanceof Fridge;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60713_(state.m_60734_()) || blockState.m_60734_() instanceof Fridge) {
            Containers.m_18992_((Level)((Level)world), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)this.fridge.get().m_5456_()));
            BlockState blockState2 = blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof IronFreezer) {
            return new FreezerBlockEntity(BlockEntities.IRON_FREEZER_BLOCK_ENTITY, pos, state);
        }
        return new FreezerBlockEntity(BlockEntities.FREEZER_BLOCK_ENTITY, pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (state.m_60734_() instanceof IronFreezer) {
            return Freezer.checkType(world, type, BlockEntities.IRON_FREEZER_BLOCK_ENTITY);
        }
        return Freezer.checkType(world, type, BlockEntities.FREEZER_BLOCK_ENTITY);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> checkType(Level world, BlockEntityType<T> givenType, BlockEntityType<? extends FreezerBlockEntity> expectedType) {
        return world.f_46443_ ? null : Freezer.m_152132_(givenType, expectedType, FreezerBlockEntity::tick);
    }
}

